/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.nustaq.offheap.bytez.malloc;

import io.hops.hadoop.shaded.org.nustaq.offheap.bytez.malloc.MallocBytez;
import java.io.File;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import sun.misc.Cleaner;
import sun.nio.ch.FileChannelImpl;

public class MMFBytez
extends MallocBytez {
    private File file;
    private FileChannel fileChannel;
    private Cleaner cleaner;
    private static final int MAP_RO = 0;
    private static final int MAP_RW = 1;
    private static final int MAP_PV = 2;

    public MMFBytez(String filePath, long length, boolean clearFile) throws Exception {
        super(0L, 0L);
        this.init(filePath, length, clearFile);
    }

    protected void init(String file, long length, boolean clearFile) throws Exception {
        File f = new File(file);
        if (f.exists() && clearFile) {
            f.delete();
        }
        this.file = f;
        if (f.exists()) {
            length = f.length();
        }
        RandomAccessFile raf = new RandomAccessFile(f, "rw");
        raf.setLength(length);
        FileChannel fileChannel = raf.getChannel();
        this.fileChannel = raf.getChannel();
        this.baseAdress = MMFBytez.map0(fileChannel, MMFBytez.imodeFor(FileChannel.MapMode.READ_WRITE), 0L, length);
        this.length = length;
        this.cleaner = Cleaner.create((Object)this, (Runnable)new Unmapper(this.baseAdress, length, fileChannel));
    }

    public void freeAndClose() {
        this.cleaner.clean();
    }

    public void _setMMFData(File file, FileChannel fileChannel, Cleaner cleaner) {
        this.file = file;
        this.fileChannel = fileChannel;
        this.cleaner = cleaner;
    }

    public File getFile() {
        return this.file;
    }

    public FileChannel getFileChannel() {
        return this.fileChannel;
    }

    public Cleaner getCleaner() {
        return this.cleaner;
    }

    private static long map0(FileChannel fileChannel, int imode, long start, long size) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method map0 = fileChannel.getClass().getDeclaredMethod("map0", Integer.TYPE, Long.TYPE, Long.TYPE);
        map0.setAccessible(true);
        return (Long)map0.invoke((Object)fileChannel, imode, start, size);
    }

    private static void unmap0(long address, long size) throws Exception {
        Method unmap0 = FileChannelImpl.class.getDeclaredMethod("unmap0", Long.TYPE, Long.TYPE);
        unmap0.setAccessible(true);
        unmap0.invoke(null, address, size);
    }

    private static int imodeFor(FileChannel.MapMode mode) {
        int imode = -1;
        if (mode == FileChannel.MapMode.READ_ONLY) {
            imode = 0;
        } else if (mode == FileChannel.MapMode.READ_WRITE) {
            imode = 1;
        } else if (mode == FileChannel.MapMode.PRIVATE) {
            imode = 2;
        }
        assert (imode >= 0);
        return imode;
    }

    static class Unmapper
    implements Runnable {
        private final long size;
        private final FileChannel channel;
        private volatile long address;

        Unmapper(long address, long size, FileChannel channel) {
            assert (address != 0L);
            this.address = address;
            this.size = size;
            this.channel = channel;
        }

        @Override
        public void run() {
            if (this.address == 0L) {
                return;
            }
            try {
                MMFBytez.unmap0(this.address, this.size);
                this.address = 0L;
                if (this.channel.isOpen()) {
                    this.channel.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

