/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import io.hops.hadoop.shaded.org.apache.commons.lang3.RandomStringUtils;
import java.io.File;
import org.apache.hadoop.fs.Path;

public class PathUtils {
    public static Path getTestPath(Class<?> caller) {
        return PathUtils.getTestPath(caller, true);
    }

    public static Path getTestPath(Class<?> caller, boolean create) {
        return new Path(PathUtils.getTestDirName(caller));
    }

    public static File getTestDir(Class<?> caller) {
        return PathUtils.getTestDir(caller, true);
    }

    public static File getTestDir(Class<?> caller, boolean create) {
        File dir = new File(System.getProperty("test.build.data", "target/test/data") + "/" + RandomStringUtils.randomAlphanumeric((int)10), caller.getSimpleName());
        if (create) {
            dir.mkdirs();
        }
        return dir;
    }

    public static String getTestDirName(Class<?> caller) {
        return PathUtils.getTestDirName(caller, true);
    }

    public static String getTestDirName(Class<?> caller, boolean create) {
        return PathUtils.getTestDir(caller, create).getAbsolutePath();
    }
}

