/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper;

import io.hops.hadoop.shaded.org.apache.zookeeper.Shell;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZKUtil;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class ZKUtilTest {
    private static final File testData = new File(System.getProperty("test.data.dir", "build/test/data"));

    @BeforeClass
    public static void init() {
        testData.mkdirs();
    }

    @Test
    public void testValidateFileInput() throws IOException {
        File file = File.createTempFile("test", ".junit", testData);
        file.deleteOnExit();
        String absolutePath = file.getAbsolutePath();
        String error = ZKUtil.validateFileInput(absolutePath);
        Assert.assertNull((Object)error);
    }

    @Test
    public void testValidateFileInputNotExist() {
        String fileName = UUID.randomUUID().toString();
        File file = new File(testData, fileName);
        String absolutePath = file.getAbsolutePath();
        String error = ZKUtil.validateFileInput(absolutePath);
        Assert.assertNotNull((Object)error);
        String expectedMessage = "File '" + absolutePath + "' does not exist.";
        Assert.assertEquals((Object)expectedMessage, (Object)error);
    }

    @Test
    public void testValidateFileInputDirectory() throws Exception {
        File file = File.createTempFile("test", ".junit", testData);
        file.deleteOnExit();
        file.delete();
        file.mkdir();
        String absolutePath = file.getAbsolutePath();
        String error = ZKUtil.validateFileInput(absolutePath);
        Assert.assertNotNull((Object)error);
        String expectedMessage = "'" + absolutePath + "' is a direcory. it must be a file.";
        Assert.assertEquals((Object)expectedMessage, (Object)error);
    }

    @Test
    public void testUnreadableFileInput() throws Exception {
        Assume.assumeTrue((!Shell.WINDOWS ? 1 : 0) != 0);
        File file = File.createTempFile("test", ".junit", testData);
        file.setReadable(false, false);
        file.deleteOnExit();
        String absolutePath = file.getAbsolutePath();
        String error = ZKUtil.validateFileInput(absolutePath);
        Assert.assertNotNull((Object)error);
        String expectedMessage = "Read permission is denied on the file '" + absolutePath + "'";
        Assert.assertEquals((Object)expectedMessage, (Object)error);
    }
}

