/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.auth;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.PortAssignment;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.admin.AdminServer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeerMain;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.auth.QuorumAuthTestBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.io.IOException;
import java.util.HashMap;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class QuorumDigestAuthTest
extends QuorumAuthTestBase {
    @Override
    @After
    public void tearDown() throws Exception {
        for (QuorumPeerTestBase.MainThread mainThread : this.mt) {
            mainThread.shutdown();
            mainThread.deleteBaseDir();
        }
        super.tearDown();
    }

    @AfterClass
    public static void cleanup() {
        QuorumDigestAuthTest.cleanupJaasConfig();
    }

    @Test(timeout=30000L)
    public void testValidCredentials() throws Exception {
        HashMap<String, String> authConfigs = new HashMap<String, String>();
        authConfigs.put("quorum.auth.enableSasl", "true");
        authConfigs.put("quorum.auth.serverRequireSasl", "true");
        authConfigs.put("quorum.auth.learnerRequireSasl", "true");
        String connectStr = this.startQuorum(3, authConfigs, 3);
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        ZooKeeper zk = new ZooKeeper(connectStr, ClientBase.CONNECTION_TIMEOUT, watcher);
        watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        for (int i = 0; i < 10; ++i) {
            zk.create("/" + i, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        zk.close();
    }

    @Test(timeout=30000L)
    public void testValidCredentialsWithMultiAddresses() throws Exception {
        HashMap<String, String> authConfigs = new HashMap<String, String>();
        authConfigs.put("quorum.auth.enableSasl", "true");
        authConfigs.put("quorum.auth.serverRequireSasl", "true");
        authConfigs.put("quorum.auth.learnerRequireSasl", "true");
        String connectStr = this.startMultiAddressQuorum(3, authConfigs, 3);
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        ZooKeeper zk = new ZooKeeper(connectStr, ClientBase.CONNECTION_TIMEOUT, watcher);
        watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        for (int i = 0; i < 10; ++i) {
            zk.create("/" + i, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        zk.close();
    }

    @Test(timeout=30000L)
    public void testSaslNotRequiredWithInvalidCredentials() throws Exception {
        HashMap<String, String> authConfigs = new HashMap<String, String>();
        authConfigs.put("quorum.auth.learner.saslLoginContext", "QuorumLearnerInvalid");
        authConfigs.put("quorum.auth.enableSasl", "false");
        authConfigs.put("quorum.auth.serverRequireSasl", "false");
        String connectStr = this.startQuorum(3, authConfigs, 3);
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        ZooKeeper zk = new ZooKeeper(connectStr, ClientBase.CONNECTION_TIMEOUT, watcher);
        watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        for (int i = 0; i < 10; ++i) {
            zk.create("/" + i, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        zk.close();
    }

    @Test(timeout=30000L)
    public void testSaslRequiredInvalidCredentials() throws Exception {
        HashMap<String, String> authConfigs = new HashMap<String, String>();
        authConfigs.put("quorum.auth.learner.saslLoginContext", "QuorumLearnerInvalid");
        authConfigs.put("quorum.auth.enableSasl", "true");
        authConfigs.put("quorum.auth.serverRequireSasl", "true");
        authConfigs.put("quorum.auth.learnerRequireSasl", "true");
        int serverCount = 2;
        int[] clientPorts = this.startQuorum(serverCount, new StringBuilder(), authConfigs, serverCount, false);
        for (int i = 0; i < serverCount; ++i) {
            boolean waitForServerUp = ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[i], 5000L);
            Assert.assertFalse((String)"Shouldn't start server with invalid credentials", (boolean)waitForServerUp);
        }
    }

    @Test(timeout=10000L)
    public void testEnableQuorumServerRequireSaslWithoutQuorumLearnerRequireSasl() throws Exception {
        HashMap<String, String> authConfigs = new HashMap<String, String>();
        authConfigs.put("quorum.auth.learner.saslLoginContext", "QuorumLearner");
        authConfigs.put("quorum.auth.enableSasl", "true");
        authConfigs.put("quorum.auth.serverRequireSasl", "true");
        authConfigs.put("quorum.auth.learnerRequireSasl", "false");
        QuorumPeerTestBase.MainThread mthread = new QuorumPeerTestBase.MainThread(1, PortAssignment.unique(), "", authConfigs);
        String[] args = new String[]{mthread.getConfFile().toString()};
        try {
            new QuorumPeerMain(){

                @Override
                protected void initializeAndRun(String[] args) throws QuorumPeerConfig.ConfigException, IOException, AdminServer.AdminServerException {
                    super.initializeAndRun(args);
                }
            }.initializeAndRun(args);
            Assert.fail((String)"Must throw exception as quorumpeer learner is not enabled!");
        }
        catch (QuorumPeerConfig.ConfigException configException) {
            // empty catch block
        }
    }

    @Test(timeout=10000L)
    public void testEnableQuorumAuthenticationConfigurations() throws Exception {
        HashMap<String, String> authConfigs = new HashMap<String, String>();
        authConfigs.put("quorum.auth.learner.saslLoginContext", "QuorumLearner");
        authConfigs.put("quorum.auth.enableSasl", "false");
        authConfigs.put("quorum.auth.serverRequireSasl", "true");
        authConfigs.put("quorum.auth.learnerRequireSasl", "false");
        QuorumPeerTestBase.MainThread mthread = new QuorumPeerTestBase.MainThread(1, PortAssignment.unique(), "", authConfigs);
        String[] args = new String[]{mthread.getConfFile().toString()};
        try {
            new QuorumPeerMain(){

                @Override
                protected void initializeAndRun(String[] args) throws QuorumPeerConfig.ConfigException, IOException, AdminServer.AdminServerException {
                    super.initializeAndRun(args);
                }
            }.initializeAndRun(args);
            Assert.fail((String)"Must throw exception as quorum sasl is not enabled!");
        }
        catch (QuorumPeerConfig.ConfigException configException) {
            // empty catch block
        }
        authConfigs.put("quorum.auth.serverRequireSasl", "false");
        authConfigs.put("quorum.auth.learnerRequireSasl", "true");
        try {
            new QuorumPeerMain(){

                @Override
                protected void initializeAndRun(String[] args) throws QuorumPeerConfig.ConfigException, IOException, AdminServer.AdminServerException {
                    super.initializeAndRun(args);
                }
            }.initializeAndRun(args);
            Assert.fail((String)"Must throw exception as quorum sasl is not enabled!");
        }
        catch (QuorumPeerConfig.ConfigException configException) {
            // empty catch block
        }
    }

    static {
        String jaasEntries = "QuorumServer {\n       org.apache.zookeeper.server.auth.DigestLoginModule required\n       user_test=\"mypassword\";\n};\nQuorumLearner {\n       org.apache.zookeeper.server.auth.DigestLoginModule required\n       username=\"test\"\n       password=\"mypassword\";\n};\nQuorumLearnerInvalid {\n       org.apache.zookeeper.server.auth.DigestLoginModule required\n       username=\"test\"\n       password=\"invalid\";\n};\n";
        QuorumDigestAuthTest.setupJaasConfig(jaasEntries);
    }
}

