/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.PortAssignment;
import io.hops.hadoop.shaded.org.apache.zookeeper.Watcher;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.admin.ZooKeeperAdmin;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.Stat;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerCnxnFactory;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.io.File;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneTest
extends QuorumPeerTestBase
implements Watcher {
    protected static final Logger LOG = LoggerFactory.getLogger(StandaloneTest.class);

    @Before
    public void setup() {
        System.setProperty("zookeeper.DigestAuthenticationProvider.superDigest", "super:D/InIHSb7yEEbrWz8b9l71RjZJU=");
        QuorumPeerConfig.setReconfigEnabled(true);
    }

    @Test
    public void testNoDynamicConfig() throws Exception {
        ClientBase.setupTestEnv();
        int CLIENT_PORT = PortAssignment.unique();
        QuorumPeerTestBase.MainThread mt = new QuorumPeerTestBase.MainThread(-1, CLIENT_PORT, "", false);
        this.verifyStandalone(mt, CLIENT_PORT);
    }

    @Test
    public void testClientPortInDynamicFile() throws Exception {
        ClientBase.setupTestEnv();
        int CLIENT_PORT = PortAssignment.unique();
        String quorumCfgSection = "server.1=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":participant;" + CLIENT_PORT + "\n";
        QuorumPeerTestBase.MainThread mt = new QuorumPeerTestBase.MainThread(1, quorumCfgSection);
        this.verifyStandalone(mt, CLIENT_PORT);
    }

    @Test
    public void testClientPortInStaticFile() throws Exception {
        ClientBase.setupTestEnv();
        int CLIENT_PORT = PortAssignment.unique();
        String quorumCfgSection = "server.1=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":participant;" + CLIENT_PORT + "\n";
        QuorumPeerTestBase.MainThread mt = new QuorumPeerTestBase.MainThread(1, quorumCfgSection, false);
        this.verifyStandalone(mt, CLIENT_PORT);
    }

    void verifyStandalone(QuorumPeerTestBase.MainThread mt, int clientPort) throws InterruptedException {
        mt.start();
        try {
            Assert.assertTrue((String)"waiting for server 1 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPort, ClientBase.CONNECTION_TIMEOUT));
        }
        finally {
            Assert.assertFalse((String)"Error- MainThread started in Quorum Mode!", (boolean)mt.isQuorumPeerRunning());
            mt.shutdown();
        }
    }

    @Test
    public void testStandaloneReconfigFails() throws Exception {
        ClientBase.setupTestEnv();
        int CLIENT_PORT = PortAssignment.unique();
        String HOSTPORT = "127.0.0.1:" + CLIENT_PORT;
        File tmpDir = ClientBase.createTmpDir();
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory(CLIENT_PORT, -1);
        f.startup(zks);
        Assert.assertTrue((String)"waiting for server being up ", (boolean)ClientBase.waitForServerUp(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        ZooKeeper zk = new ZooKeeper(HOSTPORT, ClientBase.CONNECTION_TIMEOUT, watcher);
        ZooKeeperAdmin zkAdmin = new ZooKeeperAdmin(HOSTPORT, ClientBase.CONNECTION_TIMEOUT, watcher);
        watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        ArrayList<String> joiners = new ArrayList<String>();
        joiners.add("server.2=localhost:1234:1235;1236");
        try {
            zkAdmin.addAuthInfo("digest", "super:test".getBytes());
            zkAdmin.reconfigure(joiners, null, null, -1L, new Stat());
            Assert.fail((String)"Reconfiguration in standalone should trigger UnimplementedException");
        }
        catch (KeeperException.UnimplementedException unimplementedException) {
            // empty catch block
        }
        zk.close();
        zks.shutdown();
        f.shutdown();
        Assert.assertTrue((String)"waiting for server being down ", (boolean)ClientBase.waitForServerDown(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
    }
}

