/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.ehcache.impl.internal.loaderwriter.writebehind.operations;

import io.hops.hadoop.shaded.org.ehcache.impl.internal.loaderwriter.writebehind.operations.SingleOperation;
import io.hops.hadoop.shaded.org.ehcache.spi.loaderwriter.CacheLoaderWriter;

public class WriteOperation<K, V>
implements SingleOperation<K, V> {
    private final K key;
    private final V value;
    private final long creationTime;

    public WriteOperation(K k, V v) {
        this(k, v, System.nanoTime());
    }

    public WriteOperation(K k, V v, long creationTime) {
        this.key = k;
        this.value = v;
        this.creationTime = creationTime;
    }

    @Override
    public void performOperation(CacheLoaderWriter<K, V> cacheWriter) throws Exception {
        cacheWriter.write(this.key, this.value);
    }

    @Override
    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    public int hashCode() {
        int hash = (int)this.getCreationTime();
        hash = hash * 31 + this.getKey().hashCode();
        return hash;
    }

    public boolean equals(Object other) {
        if (other instanceof WriteOperation) {
            return this.getCreationTime() == ((WriteOperation)other).getCreationTime() && this.getKey().equals(((WriteOperation)other).getKey());
        }
        return false;
    }
}

