/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsResourceCalculator;
import org.apache.hadoop.yarn.util.ProcfsBasedProcessTree;
import org.apache.hadoop.yarn.util.ResourceCalculatorProcessTree;

public class CombinedResourceCalculator
extends ResourceCalculatorProcessTree {
    protected static final Log LOG = LogFactory.getLog(CombinedResourceCalculator.class);
    private ProcfsBasedProcessTree procfs;
    private CGroupsResourceCalculator cgroup;

    public CombinedResourceCalculator(String pid) {
        super(pid);
        this.procfs = new ProcfsBasedProcessTree(pid);
        this.cgroup = new CGroupsResourceCalculator(pid);
    }

    public void initialize() throws YarnException {
        this.procfs.initialize();
        this.cgroup.initialize();
    }

    public void updateProcessTree() {
        this.procfs.updateProcessTree();
        this.cgroup.updateProcessTree();
    }

    public String getProcessTreeDump() {
        return this.procfs.getProcessTreeDump();
    }

    public float getCpuUsagePercent() {
        float cgroupUsage = this.cgroup.getCpuUsagePercent();
        if (LOG.isDebugEnabled()) {
            float procfsUsage = this.procfs.getCpuUsagePercent();
            LOG.debug((Object)("CPU Comparison:" + procfsUsage + " " + cgroupUsage));
            LOG.debug((Object)("Jiffy Comparison:" + this.procfs.getCumulativeCpuTime() + " " + this.cgroup.getCumulativeCpuTime()));
        }
        return cgroupUsage;
    }

    public boolean checkPidPgrpidForMatch() {
        return this.procfs.checkPidPgrpidForMatch();
    }

    public long getCumulativeCpuTime() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("CPU Comparison:" + this.procfs.getCumulativeCpuTime() + " " + this.cgroup.getCumulativeCpuTime()));
        }
        return this.cgroup.getCumulativeCpuTime();
    }

    public long getRssMemorySize(int olderThanAge) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("MEM Comparison:" + this.procfs.getRssMemorySize(olderThanAge) + " " + this.cgroup.getRssMemorySize(olderThanAge)));
        }
        return this.cgroup.getRssMemorySize(olderThanAge);
    }

    public long getVirtualMemorySize(int olderThanAge) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("VMEM Comparison:" + this.procfs.getVirtualMemorySize(olderThanAge) + " " + this.cgroup.getVirtualMemorySize(olderThanAge)));
        }
        return this.procfs.getVirtualMemorySize(olderThanAge);
    }
}

