/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server;

import io.hops.hadoop.shaded.org.apache.zookeeper.AsyncCallback;
import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.Op;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.Stat;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ContainerManager;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.DataNode;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.DataTree;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.Request;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.RequestProcessor;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZKDatabase;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Test;

public class CreateContainerTest
extends ClientBase {
    private ZooKeeper zk;
    private Semaphore completedContainerDeletions;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.zk = this.createClient();
        this.completedContainerDeletions = new Semaphore(0);
        ZKDatabase testDatabase = new ZKDatabase(this.serverFactory.zkServer.getZKDatabase().snapLog){

            @Override
            public void addCommittedProposal(Request request) {
                super.addCommittedProposal(request);
                if (request.type == 20) {
                    CreateContainerTest.this.completedContainerDeletions.release();
                }
            }
        };
        this.serverFactory.zkServer.setZKDatabase(testDatabase);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.zk.close();
    }

    @Test(timeout=30000L)
    public void testCreate() throws KeeperException, InterruptedException {
        this.createNoStatVerifyResult("/foo");
        this.createNoStatVerifyResult("/foo/child");
    }

    @Test(timeout=30000L)
    public void testCreateWithStat() throws KeeperException, InterruptedException {
        Stat stat = this.createWithStatVerifyResult("/foo");
        Stat childStat = this.createWithStatVerifyResult("/foo/child");
        Assert.assertFalse((boolean)stat.equals(childStat));
    }

    @Test(timeout=30000L)
    public void testCreateWithNullStat() throws KeeperException, InterruptedException {
        String name = "/foo";
        Assert.assertNull((Object)this.zk.exists("/foo", false));
        Stat stat = null;
        this.zk.create("/foo", "/foo".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.CONTAINER, stat);
        Assert.assertNull(stat);
        Assert.assertNotNull((Object)this.zk.exists("/foo", false));
    }

    @Test(timeout=30000L)
    public void testSimpleDeletion() throws KeeperException, InterruptedException {
        this.zk.create("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.CONTAINER);
        this.zk.create("/foo/bar", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.delete("/foo/bar", -1);
        ContainerManager containerManager = new ContainerManager(this.serverFactory.getZooKeeperServer().getZKDatabase(), this.serverFactory.getZooKeeperServer().firstProcessor, 1, 100);
        containerManager.checkContainers();
        Assert.assertTrue((boolean)this.completedContainerDeletions.tryAcquire(1L, TimeUnit.SECONDS));
        Assert.assertNull((String)"Container should have been deleted", (Object)this.zk.exists("/foo", false));
    }

    @Test(timeout=30000L)
    public void testMultiWithContainerSimple() throws KeeperException, InterruptedException {
        Op createContainer = Op.create("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.CONTAINER);
        this.zk.multi(Collections.singletonList(createContainer));
        DataTree dataTree = this.serverFactory.getZooKeeperServer().getZKDatabase().getDataTree();
        Assert.assertEquals((long)dataTree.getContainers().size(), (long)1L);
    }

    @Test(timeout=30000L)
    public void testMultiWithContainer() throws KeeperException, InterruptedException {
        Op createContainer = Op.create("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.CONTAINER);
        Op createChild = Op.create("/foo/bar", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.multi(Arrays.asList(createContainer, createChild));
        DataTree dataTree = this.serverFactory.getZooKeeperServer().getZKDatabase().getDataTree();
        Assert.assertEquals((long)dataTree.getContainers().size(), (long)1L);
        this.zk.delete("/foo/bar", -1);
        ContainerManager containerManager = new ContainerManager(this.serverFactory.getZooKeeperServer().getZKDatabase(), this.serverFactory.getZooKeeperServer().firstProcessor, 1, 100);
        containerManager.checkContainers();
        Assert.assertTrue((boolean)this.completedContainerDeletions.tryAcquire(1L, TimeUnit.SECONDS));
        Assert.assertNull((String)"Container should have been deleted", (Object)this.zk.exists("/foo", false));
        createContainer = Op.create("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.CONTAINER);
        createChild = Op.create("/foo/bar", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Op deleteChild = Op.delete("/foo/bar", -1);
        this.zk.multi(Arrays.asList(createContainer, createChild, deleteChild));
        containerManager.checkContainers();
        Assert.assertTrue((boolean)this.completedContainerDeletions.tryAcquire(1L, TimeUnit.SECONDS));
        Assert.assertNull((String)"Container should have been deleted", (Object)this.zk.exists("/foo", false));
    }

    @Test(timeout=30000L)
    public void testSimpleDeletionAsync() throws KeeperException, InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        AsyncCallback.Create2Callback cb = new AsyncCallback.Create2Callback(){

            @Override
            public void processResult(int rc, String path, Object ctx, String name, Stat stat) {
                Assert.assertEquals((Object)ctx, (Object)"context");
                latch.countDown();
            }
        };
        this.zk.create("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.CONTAINER, cb, (Object)"context");
        Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        this.zk.create("/foo/bar", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.delete("/foo/bar", -1);
        ContainerManager containerManager = new ContainerManager(this.serverFactory.getZooKeeperServer().getZKDatabase(), this.serverFactory.getZooKeeperServer().firstProcessor, 1, 100);
        containerManager.checkContainers();
        Assert.assertTrue((boolean)this.completedContainerDeletions.tryAcquire(1L, TimeUnit.SECONDS));
        Assert.assertNull((String)"Container should have been deleted", (Object)this.zk.exists("/foo", false));
    }

    @Test(timeout=30000L)
    public void testCascadingDeletion() throws KeeperException, InterruptedException {
        this.zk.create("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.CONTAINER);
        this.zk.create("/foo/bar", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.CONTAINER);
        this.zk.create("/foo/bar/one", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.delete("/foo/bar/one", -1);
        ContainerManager containerManager = new ContainerManager(this.serverFactory.getZooKeeperServer().getZKDatabase(), this.serverFactory.getZooKeeperServer().firstProcessor, 1, 100);
        containerManager.checkContainers();
        Assert.assertTrue((boolean)this.completedContainerDeletions.tryAcquire(1L, TimeUnit.SECONDS));
        containerManager.checkContainers();
        Assert.assertTrue((boolean)this.completedContainerDeletions.tryAcquire(1L, TimeUnit.SECONDS));
        Assert.assertNull((String)"Container should have been deleted", (Object)this.zk.exists("/foo/bar", false));
        Assert.assertNull((String)"Container should have been deleted", (Object)this.zk.exists("/foo", false));
    }

    @Test(timeout=30000L)
    public void testFalseEmpty() throws KeeperException, InterruptedException {
        this.zk.create("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.CONTAINER);
        this.zk.create("/foo/bar", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        ContainerManager containerManager = new ContainerManager(this.serverFactory.getZooKeeperServer().getZKDatabase(), this.serverFactory.getZooKeeperServer().firstProcessor, 1, 100){

            @Override
            protected Collection<String> getCandidates() {
                return Collections.singletonList("/foo");
            }
        };
        containerManager.checkContainers();
        Assert.assertTrue((boolean)this.completedContainerDeletions.tryAcquire(1L, TimeUnit.SECONDS));
        Assert.assertNotNull((String)"Container should have not been deleted", (Object)this.zk.exists("/foo", false));
    }

    @Test(timeout=30000L)
    public void testMaxPerMinute() throws InterruptedException {
        final LinkedBlockingQueue queue = new LinkedBlockingQueue();
        RequestProcessor processor = new RequestProcessor(){

            @Override
            public void processRequest(Request request) {
                queue.add(new String(request.request.array()));
            }

            @Override
            public void shutdown() {
            }
        };
        final ContainerManager containerManager = new ContainerManager(this.serverFactory.getZooKeeperServer().getZKDatabase(), processor, 1, 2){

            @Override
            protected long getMinIntervalMs() {
                return 1000L;
            }

            @Override
            protected Collection<String> getCandidates() {
                return Arrays.asList("/one", "/two", "/three", "/four");
            }
        };
        Executors.newSingleThreadExecutor().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                containerManager.checkContainers();
                return null;
            }
        });
        Assert.assertEquals(queue.poll(5L, TimeUnit.SECONDS), (Object)"/one");
        Assert.assertEquals(queue.poll(5L, TimeUnit.SECONDS), (Object)"/two");
        Assert.assertEquals((long)queue.size(), (long)0L);
        Thread.sleep(500L);
        Assert.assertEquals((long)queue.size(), (long)0L);
        Assert.assertEquals(queue.poll(5L, TimeUnit.SECONDS), (Object)"/three");
        Assert.assertEquals(queue.poll(5L, TimeUnit.SECONDS), (Object)"/four");
    }

    @Test(timeout=30000L)
    public void testMaxNeverUsedInterval() throws KeeperException, InterruptedException {
        this.zk.create("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.CONTAINER);
        final AtomicLong elapsed = new AtomicLong(0L);
        final AtomicInteger deletesQty = new AtomicInteger(0);
        ContainerManager containerManager = new ContainerManager(this.serverFactory.getZooKeeperServer().getZKDatabase(), this.serverFactory.getZooKeeperServer().firstProcessor, 1, 100, 1000L){

            @Override
            protected void postDeleteRequest(Request request) throws RequestProcessor.RequestProcessorException {
                deletesQty.incrementAndGet();
                super.postDeleteRequest(request);
            }

            @Override
            protected long getElapsed(DataNode node) {
                return elapsed.get();
            }
        };
        containerManager.checkContainers();
        Assert.assertEquals((long)deletesQty.get(), (long)0L);
        Assert.assertNotNull((String)"Container should not have been deleted", (Object)this.zk.exists("/foo", false));
        elapsed.set(10000L);
        containerManager.checkContainers();
        Assert.assertTrue((boolean)this.completedContainerDeletions.tryAcquire(1L, TimeUnit.SECONDS));
        Assert.assertNull((String)"Container should have been deleted", (Object)this.zk.exists("/foo", false));
    }

    @Test(timeout=30000L)
    public void testZeroMaxNeverUsedInterval() throws KeeperException, InterruptedException {
        this.zk.create("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.CONTAINER);
        final AtomicInteger deletesQty = new AtomicInteger(0);
        ContainerManager containerManager = new ContainerManager(this.serverFactory.getZooKeeperServer().getZKDatabase(), this.serverFactory.getZooKeeperServer().firstProcessor, 1, 100, 0L){

            @Override
            protected void postDeleteRequest(Request request) throws RequestProcessor.RequestProcessorException {
                deletesQty.incrementAndGet();
                super.postDeleteRequest(request);
            }

            @Override
            protected long getElapsed(DataNode node) {
                return 10000L;
            }
        };
        containerManager.checkContainers();
        Assert.assertEquals((long)deletesQty.get(), (long)0L);
        Assert.assertNotNull((String)"Container should not have been deleted", (Object)this.zk.exists("/foo", false));
    }

    private void createNoStatVerifyResult(String newName) throws KeeperException, InterruptedException {
        Assert.assertNull((String)"Node existed before created", (Object)this.zk.exists(newName, false));
        this.zk.create(newName, newName.getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.CONTAINER);
        Assert.assertNotNull((String)"Node was not created as expected", (Object)this.zk.exists(newName, false));
    }

    private Stat createWithStatVerifyResult(String newName) throws KeeperException, InterruptedException {
        Assert.assertNull((String)"Node existed before created", (Object)this.zk.exists(newName, false));
        Stat stat = new Stat();
        this.zk.create(newName, newName.getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.CONTAINER, stat);
        this.validateCreateStat(stat, newName);
        Stat referenceStat = this.zk.exists(newName, false);
        Assert.assertNotNull((String)"Node was not created as expected", (Object)referenceStat);
        Assert.assertEquals((Object)referenceStat, (Object)stat);
        return stat;
    }

    private void validateCreateStat(Stat stat, String name) {
        Assert.assertEquals((long)stat.getCzxid(), (long)stat.getMzxid());
        Assert.assertEquals((long)stat.getCzxid(), (long)stat.getPzxid());
        Assert.assertEquals((long)stat.getCtime(), (long)stat.getMtime());
        Assert.assertEquals((long)0L, (long)stat.getCversion());
        Assert.assertEquals((long)0L, (long)stat.getVersion());
        Assert.assertEquals((long)0L, (long)stat.getAversion());
        Assert.assertEquals((long)0L, (long)stat.getEphemeralOwner());
        Assert.assertEquals((long)name.length(), (long)stat.getDataLength());
        Assert.assertEquals((long)0L, (long)stat.getNumChildren());
    }
}

