/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.cli;

import io.hops.hadoop.shaded.org.apache.commons.cli.CommandLine;
import io.hops.hadoop.shaded.org.apache.commons.cli.Options;
import io.hops.hadoop.shaded.org.apache.commons.cli.ParseException;
import io.hops.hadoop.shaded.org.apache.commons.cli.PosixParser;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.cli.CliCommand;
import io.hops.hadoop.shaded.org.apache.zookeeper.cli.CliException;
import io.hops.hadoop.shaded.org.apache.zookeeper.cli.CliParseException;
import io.hops.hadoop.shaded.org.apache.zookeeper.cli.CliWrapperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.cli.MalformedPathException;
import java.util.List;

public class GetEphemeralsCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;

    public GetEphemeralsCommand() {
        super("getEphemerals", "path");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        CommandLine cl;
        PosixParser parser = new PosixParser();
        try {
            cl = parser.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = cl.getArgs();
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        List<String> ephemerals;
        try {
            if (this.args.length < 2) {
                ephemerals = this.zk.getEphemerals();
            } else {
                String path = this.args[1];
                ephemerals = this.zk.getEphemerals(path);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        catch (KeeperException | InterruptedException ex) {
            throw new CliWrapperException(ex);
        }
        this.out.println(ephemerals);
        return false;
    }
}

