/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.TestableZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.Stat;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ContainerManager;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.DataNode;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.DataTree;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.EphemeralType;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.EphemeralTypeEmulate353;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import io.hops.hadoop.shaded.org.hamcrest.CoreMatchers;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Test;

public class Emulate353TTLTest
extends ClientBase {
    private TestableZooKeeper zk;

    @Override
    public void setUp() throws Exception {
        System.setProperty("zookeeper.extendedTypesEnabled", "true");
        System.setProperty("zookeeper.emulate353TTLNodes", "true");
        super.setUp();
        this.zk = this.createClient();
    }

    @Override
    public void tearDown() throws Exception {
        System.clearProperty("zookeeper.extendedTypesEnabled");
        System.clearProperty("zookeeper.emulate353TTLNodes");
        super.tearDown();
        this.zk.close();
    }

    @Test
    public void testCreate() throws KeeperException, InterruptedException {
        Stat stat = new Stat();
        this.zk.create("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_WITH_TTL, stat, 100L);
        Assert.assertEquals((long)0L, (long)stat.getEphemeralOwner());
        AtomicLong fakeElapsed = new AtomicLong(0L);
        ContainerManager containerManager = this.newContainerManager(fakeElapsed);
        containerManager.checkContainers();
        Assert.assertNotNull((String)"Ttl node should not have been deleted yet", (Object)this.zk.exists("/foo", false));
        fakeElapsed.set(1000L);
        containerManager.checkContainers();
        Assert.assertNull((String)"Ttl node should have been deleted", (Object)this.zk.exists("/foo", false));
    }

    @Test
    public void test353TTL() throws KeeperException, InterruptedException {
        DataTree dataTree = this.serverFactory.zkServer.getZKDatabase().dataTree;
        long ephemeralOwner = EphemeralTypeEmulate353.ttlToEphemeralOwner(100L);
        dataTree.createNode("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, ephemeralOwner, dataTree.getNode((String)"/").stat.getCversion() + 1, 1L, 1L);
        AtomicLong fakeElapsed = new AtomicLong(0L);
        ContainerManager containerManager = this.newContainerManager(fakeElapsed);
        containerManager.checkContainers();
        Assert.assertNotNull((String)"Ttl node should not have been deleted yet", (Object)this.zk.exists("/foo", false));
        fakeElapsed.set(1000L);
        containerManager.checkContainers();
        Assert.assertNull((String)"Ttl node should have been deleted", (Object)this.zk.exists("/foo", false));
    }

    @Test
    public void testEphemeralOwner_emulationTTL() {
        Assert.assertThat((Object)((Object)EphemeralType.get(-1L)), CoreMatchers.equalTo(EphemeralType.TTL));
    }

    @Test
    public void testEphemeralOwner_emulationContainer() {
        Assert.assertThat((Object)((Object)EphemeralType.get(Long.MIN_VALUE)), CoreMatchers.equalTo(EphemeralType.CONTAINER));
    }

    private ContainerManager newContainerManager(final AtomicLong fakeElapsed) {
        return new ContainerManager(this.serverFactory.getZooKeeperServer().getZKDatabase(), this.serverFactory.getZooKeeperServer().firstProcessor, 1, 100){

            @Override
            protected long getElapsed(DataNode node) {
                return fakeElapsed.get();
            }
        };
    }
}

