/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum;

import io.hops.hadoop.shaded.org.apache.zookeeper.common.ClientX509Util;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;

public class QuorumPeerConfigTest {
    @Test
    public void testErrorMessageWhensecureClientPortNotSetButsecureClientPortAddressSet() throws IOException, QuorumPeerConfig.ConfigException {
        QuorumPeerConfig quorumPeerConfig = new QuorumPeerConfig();
        try {
            Properties zkProp = this.getDefaultZKProperties();
            zkProp.setProperty("secureClientPortAddress", "localhost");
            quorumPeerConfig.parseProperties(zkProp);
            Assert.fail((String)"IllegalArgumentException is expected");
        }
        catch (IllegalArgumentException e) {
            String expectedMessage = "secureClientPortAddress is set but secureClientPort is not set";
            Assert.assertEquals((Object)expectedMessage, (Object)e.getMessage());
        }
    }

    @Test
    public void testErrorMessageWhenclientPortNotSetButclientPortAddressSet() throws IOException, QuorumPeerConfig.ConfigException {
        QuorumPeerConfig quorumPeerConfig = new QuorumPeerConfig();
        try {
            Properties zkProp = this.getDefaultZKProperties();
            zkProp.setProperty("clientPortAddress", "localhost");
            quorumPeerConfig.parseProperties(zkProp);
            Assert.fail((String)"IllegalArgumentException is expected");
        }
        catch (IllegalArgumentException e) {
            String expectedMessage = "clientPortAddress is set but clientPort is not set";
            Assert.assertEquals((Object)expectedMessage, (Object)e.getMessage());
        }
    }

    @Test
    public void testConfigureSSLAuthGetsConfiguredIfSecurePortConfigured() throws IOException, QuorumPeerConfig.ConfigException {
        String sslAuthProp = "zookeeper.authProvider.x509";
        QuorumPeerConfig quorumPeerConfig = new QuorumPeerConfig();
        Properties zkProp = this.getDefaultZKProperties();
        zkProp.setProperty("secureClientPort", "12345");
        quorumPeerConfig.parseProperties(zkProp);
        String expected = "io.hops.hadoop.shaded.org.apache.zookeeper.server.auth.X509AuthenticationProvider";
        String result = System.getProperty(sslAuthProp);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testCustomSSLAuth() throws IOException {
        try (ClientX509Util x509Util = new ClientX509Util();){
            System.setProperty(x509Util.getSslAuthProviderProperty(), "y509");
            QuorumPeerConfig quorumPeerConfig = new QuorumPeerConfig();
            try {
                Properties zkProp = this.getDefaultZKProperties();
                zkProp.setProperty("secureClientPort", "12345");
                quorumPeerConfig.parseProperties(zkProp);
                Assert.fail((String)"ConfigException is expected");
            }
            catch (QuorumPeerConfig.ConfigException e) {
                Assert.assertNotNull((Object)e.getMessage());
            }
        }
    }

    @Test(expected=QuorumPeerConfig.ConfigException.class)
    public void testSamePortConfiguredForClientAndElection() throws IOException, QuorumPeerConfig.ConfigException {
        QuorumPeerConfig quorumPeerConfig = new QuorumPeerConfig();
        Properties zkProp = this.getDefaultZKProperties();
        zkProp.setProperty("server.1", "localhost:2888:2888");
        quorumPeerConfig.parseProperties(zkProp);
    }

    @Test
    public void testClientAddrFromClientPort() throws IOException, QuorumPeerConfig.ConfigException {
        long serverId = 1L;
        MockQuorumPeerConfig quorumPeerConfig = new MockQuorumPeerConfig(serverId);
        Properties zkProp = this.getDefaultZKProperties();
        int clientPort = 12345;
        zkProp.setProperty("clientPort", Integer.toString(clientPort));
        zkProp.setProperty("server.1", "127.0.0.1:2889:3889:participant");
        quorumPeerConfig.parseProperties(zkProp);
        QuorumPeer.QuorumServer qs = quorumPeerConfig.getQuorumVerifier().getAllMembers().get(serverId);
        InetSocketAddress expectedAddress = new InetSocketAddress("0.0.0.0", clientPort);
        Assert.assertEquals((Object)expectedAddress, (Object)quorumPeerConfig.getClientPortAddress());
        Assert.assertEquals((Object)quorumPeerConfig.getClientPortAddress(), (Object)qs.clientAddr);
    }

    @Test
    public void testJvmPauseMonitorConfigured() throws IOException, QuorumPeerConfig.ConfigException {
        Long sleepTime = 444L;
        Long warnTH = 5555L;
        Long infoTH = 555L;
        QuorumPeerConfig quorumPeerConfig = new QuorumPeerConfig();
        Properties zkProp = this.getDefaultZKProperties();
        zkProp.setProperty("dataDir", new File("myDataDir").getAbsolutePath());
        zkProp.setProperty("jvm.pause.monitor", "true");
        zkProp.setProperty("jvm.pause.sleep.time.ms", sleepTime.toString());
        zkProp.setProperty("jvm.pause.warn-threshold.ms", warnTH.toString());
        zkProp.setProperty("jvm.pause.info-threshold.ms", infoTH.toString());
        quorumPeerConfig.parseProperties(zkProp);
        Assert.assertEquals((Object)sleepTime, (Object)quorumPeerConfig.getJvmPauseSleepTimeMs());
        Assert.assertEquals((Object)warnTH, (Object)quorumPeerConfig.getJvmPauseWarnThresholdMs());
        Assert.assertEquals((Object)infoTH, (Object)quorumPeerConfig.getJvmPauseInfoThresholdMs());
        Assert.assertTrue((boolean)quorumPeerConfig.isJvmPauseMonitorToRun());
    }

    private Properties getDefaultZKProperties() {
        Properties zkProp = new Properties();
        zkProp.setProperty("dataDir", new File("myDataDir").getAbsolutePath());
        return zkProp;
    }

    public static class MockQuorumPeerConfig
    extends QuorumPeerConfig {
        public MockQuorumPeerConfig(long serverId) {
            this.serverId = serverId;
        }
    }
}

