/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.WatchedEvent;
import io.hops.hadoop.shaded.org.apache.zookeeper.Watcher;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisconnectedWatcherTest
extends ClientBase {
    protected static final Logger LOG = LoggerFactory.getLogger(DisconnectedWatcherTest.class);
    final int TIMEOUT = 5000;
    private ClientBase.CountdownWatcher watcher1;
    private ZooKeeper zk1;
    private MyWatcher watcher2;
    private ZooKeeper zk2;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.watcher1 = new ClientBase.CountdownWatcher();
        this.zk1 = this.createClient(this.watcher1);
        this.watcher2 = new MyWatcher();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (this.zk2 != null) {
            this.zk2.close();
        }
        if (this.zk1 != null) {
            this.zk1.close();
        }
        super.tearDown();
    }

    @Test
    public void testChildWatcherAutoResetWithChroot() throws Exception {
        this.zk1.create("/ch1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk2 = this.createClient(this.watcher2, this.hostPort + "/ch1");
        this.zk2.getChildren("/", true);
        this.zk1.create("/youdontmatter1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk1.create("/ch1/youshouldmatter1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        WatchedEvent e = this.watcher2.events.poll(5000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)e);
        Assert.assertEquals((Object)((Object)Watcher.Event.EventType.NodeChildrenChanged), (Object)((Object)e.getType()));
        Assert.assertEquals((Object)"/", (Object)e.getPath());
        MyWatcher childWatcher = new MyWatcher();
        this.zk2.getChildren("/", childWatcher);
        this.stopServer();
        this.watcher2.waitForDisconnected(3000L);
        this.startServer();
        this.watcher2.waitForConnected(3000L);
        this.watcher1.waitForConnected(3000L);
        this.zk1.create("/ch1/youshouldmatter2", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        e = childWatcher.events.poll(5000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)e);
        Assert.assertEquals((Object)((Object)Watcher.Event.EventType.NodeChildrenChanged), (Object)((Object)e.getType()));
        Assert.assertEquals((Object)"/", (Object)e.getPath());
    }

    @Test
    public void testDefaultWatcherAutoResetWithChroot() throws Exception {
        this.zk1.create("/ch1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk2 = this.createClient(this.watcher2, this.hostPort + "/ch1");
        this.zk2.getChildren("/", true);
        this.zk1.create("/youdontmatter1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk1.create("/ch1/youshouldmatter1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        WatchedEvent e = this.watcher2.events.poll(5000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)e);
        Assert.assertEquals((Object)((Object)Watcher.Event.EventType.NodeChildrenChanged), (Object)((Object)e.getType()));
        Assert.assertEquals((Object)"/", (Object)e.getPath());
        this.zk2.getChildren("/", true);
        this.stopServer();
        this.watcher2.waitForDisconnected(3000L);
        this.startServer();
        this.watcher2.waitForConnected(3000L);
        this.watcher1.waitForConnected(3000L);
        this.zk1.create("/ch1/youshouldmatter2", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        e = this.watcher2.events.poll(5000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)e);
        Assert.assertEquals((Object)((Object)Watcher.Event.EventType.NodeChildrenChanged), (Object)((Object)e.getType()));
        Assert.assertEquals((Object)"/", (Object)e.getPath());
    }

    @Test
    public void testDeepChildWatcherAutoResetWithChroot() throws Exception {
        this.zk1.create("/ch1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk1.create("/ch1/here", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk1.create("/ch1/here/we", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk1.create("/ch1/here/we/are", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk2 = this.createClient(this.watcher2, this.hostPort + "/ch1/here/we");
        this.zk2.getChildren("/are", true);
        this.zk1.create("/ch1/here/we/are/now", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        WatchedEvent e = this.watcher2.events.poll(5000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)e);
        Assert.assertEquals((Object)((Object)Watcher.Event.EventType.NodeChildrenChanged), (Object)((Object)e.getType()));
        Assert.assertEquals((Object)"/are", (Object)e.getPath());
        MyWatcher childWatcher = new MyWatcher();
        this.zk2.getChildren("/are", childWatcher);
        this.stopServer();
        this.watcher2.waitForDisconnected(3000L);
        this.startServer();
        this.watcher2.waitForConnected(3000L);
        this.watcher1.waitForConnected(3000L);
        this.zk1.create("/ch1/here/we/are/again", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        e = childWatcher.events.poll(5000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)e);
        Assert.assertEquals((Object)((Object)Watcher.Event.EventType.NodeChildrenChanged), (Object)((Object)e.getType()));
        Assert.assertEquals((Object)"/are", (Object)e.getPath());
    }

    @Test(timeout=840000L)
    public void testManyChildWatchersAutoReset() throws Exception {
        this.zk2 = this.createClient(this.watcher2);
        String pathBase = "/long-path-000000000-111111111-222222222-333333333-444444444-555555555-666666666-777777777-888888888-999999999";
        this.zk1.create(pathBase, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        ArrayList<String> paths = new ArrayList<String>();
        for (int i = 0; i < 10000; ++i) {
            String path = this.zk1.create(pathBase + "/ch-", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
            paths.add(path);
        }
        LOG.info("Created 10,000 nodes.");
        MyWatcher childWatcher = new MyWatcher();
        int i = 0;
        for (String path : paths) {
            if (i % 3 == 0) {
                this.zk2.getChildren(path, childWatcher);
            } else if (i % 3 == 1) {
                this.zk2.exists(path + "/foo", childWatcher);
            } else if (i % 3 == 2) {
                this.zk2.getData(path, childWatcher, null);
            }
            ++i;
        }
        this.stopServer();
        this.watcher2.waitForDisconnected(30000L);
        this.startServer();
        this.watcher2.waitForConnected(30000L);
        this.watcher1.waitForConnected(30000L);
        i = 0;
        for (String path : paths) {
            WatchedEvent e;
            if (i % 3 == 0) {
                this.zk1.create(path + "/ch", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                e = childWatcher.events.poll(5000L, TimeUnit.MILLISECONDS);
                Assert.assertNotNull((Object)e);
                Assert.assertEquals((Object)((Object)Watcher.Event.EventType.NodeChildrenChanged), (Object)((Object)e.getType()));
                Assert.assertEquals((Object)path, (Object)e.getPath());
            } else if (i % 3 == 1) {
                this.zk1.create(path + "/foo", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                e = childWatcher.events.poll(5000L, TimeUnit.MILLISECONDS);
                Assert.assertNotNull((Object)e);
                Assert.assertEquals((Object)((Object)Watcher.Event.EventType.NodeCreated), (Object)((Object)e.getType()));
                Assert.assertEquals((Object)(path + "/foo"), (Object)e.getPath());
            } else if (i % 3 == 2) {
                this.zk1.setData(path, new byte[]{1, 2, 3}, -1);
                e = childWatcher.events.poll(5000L, TimeUnit.MILLISECONDS);
                Assert.assertNotNull((Object)e);
                Assert.assertEquals((Object)((Object)Watcher.Event.EventType.NodeDataChanged), (Object)((Object)e.getType()));
                Assert.assertEquals((Object)path, (Object)e.getPath());
            }
            ++i;
        }
    }

    private class MyWatcher
    extends ClientBase.CountdownWatcher {
        LinkedBlockingQueue<WatchedEvent> events = new LinkedBlockingQueue();

        private MyWatcher() {
        }

        @Override
        public void process(WatchedEvent event) {
            super.process(event);
            if (event.getType() != Watcher.Event.EventType.None) {
                try {
                    this.events.put(event);
                }
                catch (InterruptedException e) {
                    LOG.warn("ignoring interrupt during event.put");
                }
            }
        }
    }
}

