/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server;

import io.hops.hadoop.shaded.org.apache.jute.BinaryInputArchive;
import io.hops.hadoop.shaded.org.apache.jute.BinaryOutputArchive;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.DataTree;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.SerializationPerfTest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeserializationPerfTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(DeserializationPerfTest.class);

    private static void deserializeTree(int depth, int width, int len) throws InterruptedException, IOException, KeeperException.NodeExistsException, KeeperException.NoNodeException {
        DataTree tree = new DataTree();
        SerializationPerfTest.createNodes(tree, "/", depth, width, tree.getNode((String)"/").stat.getCversion(), new byte[len]);
        int count = tree.getNodeCount();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive oa = BinaryOutputArchive.getArchive(baos);
        tree.serialize(oa, "test");
        baos.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        BinaryInputArchive ia = BinaryInputArchive.getArchive(bais);
        DataTree dserTree = new DataTree();
        System.gc();
        long start = System.nanoTime();
        dserTree.deserialize(ia, "test");
        long end = System.nanoTime();
        long durationms = (end - start) / 1000000L;
        long pernodeus = (end - start) / 1000L / (long)count;
        Assert.assertEquals((long)count, (long)dserTree.getNodeCount());
        LOG.info("Deserialized {} nodes in {} ms ({}us/node), depth={} width={} datalen={}", new Object[]{count, durationms, pernodeus, depth, width, len});
    }

    @Test
    public void testSingleDeserialize() throws InterruptedException, IOException, KeeperException.NodeExistsException, KeeperException.NoNodeException {
        DeserializationPerfTest.deserializeTree(1, 0, 20);
    }

    @Test
    public void testWideDeserialize() throws InterruptedException, IOException, KeeperException.NodeExistsException, KeeperException.NoNodeException {
        DeserializationPerfTest.deserializeTree(2, 10000, 20);
    }

    @Test
    public void testDeepDeserialize() throws InterruptedException, IOException, KeeperException.NodeExistsException, KeeperException.NoNodeException {
        DeserializationPerfTest.deserializeTree(400, 1, 20);
    }

    @Test
    public void test10Wide5DeepDeserialize() throws InterruptedException, IOException, KeeperException.NodeExistsException, KeeperException.NoNodeException {
        DeserializationPerfTest.deserializeTree(5, 10, 20);
    }

    @Test
    public void test15Wide5DeepDeserialize() throws InterruptedException, IOException, KeeperException.NodeExistsException, KeeperException.NoNodeException {
        DeserializationPerfTest.deserializeTree(5, 15, 20);
    }

    @Test
    public void test25Wide4DeepDeserialize() throws InterruptedException, IOException, KeeperException.NodeExistsException, KeeperException.NoNodeException {
        DeserializationPerfTest.deserializeTree(4, 25, 20);
    }

    @Test
    public void test40Wide4DeepDeserialize() throws InterruptedException, IOException, KeeperException.NodeExistsException, KeeperException.NoNodeException {
        DeserializationPerfTest.deserializeTree(4, 40, 20);
    }

    @Test
    public void test300Wide3DeepDeserialize() throws InterruptedException, IOException, KeeperException.NodeExistsException, KeeperException.NoNodeException {
        DeserializationPerfTest.deserializeTree(3, 300, 20);
    }
}

