/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum;

import io.hops.hadoop.shaded.org.apache.zookeeper.server.Request;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.RequestProcessor;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.FollowerZooKeeperServer;
import java.util.concurrent.LinkedBlockingQueue;

public class DelayRequestProcessor
implements RequestProcessor {
    private boolean blocking = true;
    RequestProcessor next;
    private LinkedBlockingQueue<Request> incomingRequests = new LinkedBlockingQueue();

    private DelayRequestProcessor(RequestProcessor next) {
        this.next = next;
    }

    @Override
    public void processRequest(Request request) throws RequestProcessor.RequestProcessorException {
        if (this.blocking) {
            this.incomingRequests.add(request);
        } else {
            this.next.processRequest(request);
        }
    }

    public void submitRequest(Request request) throws RequestProcessor.RequestProcessorException {
        this.next.processRequest(request);
    }

    @Override
    public void shutdown() {
    }

    public void unblockQueue() throws RequestProcessor.RequestProcessorException {
        if (this.blocking) {
            for (Request request : this.incomingRequests) {
                this.next.processRequest(request);
            }
            this.blocking = false;
        }
    }

    public static DelayRequestProcessor injectDelayRequestProcessor(FollowerZooKeeperServer zooKeeperServer) {
        RequestProcessor finalRequestProcessor = zooKeeperServer.commitProcessor.nextProcessor;
        DelayRequestProcessor delayRequestProcessor = new DelayRequestProcessor(finalRequestProcessor);
        zooKeeperServer.commitProcessor.nextProcessor = delayRequestProcessor;
        return delayRequestProcessor;
    }
}

