/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.util;

import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.util.BitMap;
import org.junit.Assert;
import org.junit.Test;

public class BitMapTest
extends ZKTestCase {
    @Test
    public void testAddAndRemove() {
        BitMap<String> bitMap = new BitMap<String>();
        String v1 = "v1";
        Integer bit = bitMap.add(v1);
        Assert.assertEquals((long)1L, (long)bitMap.size());
        Assert.assertTrue((bit >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)v1, bitMap.get(bit));
        Assert.assertEquals((Object)bit, (Object)bitMap.getBit(v1));
        Integer newBit = bitMap.add(v1);
        Assert.assertEquals((Object)bit, (Object)newBit);
        Assert.assertEquals((long)1L, (long)bitMap.size());
        String v2 = "v2";
        Integer v2Bit = bitMap.add(v2);
        Assert.assertEquals((long)2L, (long)bitMap.size());
        Assert.assertNotEquals((Object)v2Bit, (Object)bit);
        bitMap.remove(v1);
        Assert.assertEquals((long)1L, (long)bitMap.size());
        Assert.assertNull(bitMap.get(bit));
        Assert.assertNull((Object)bitMap.getBit(v1));
        bitMap.remove(v2Bit);
        Assert.assertEquals((long)0L, (long)bitMap.size());
        Assert.assertNull(bitMap.get(v2Bit));
        Assert.assertNull((Object)bitMap.getBit(v2));
    }

    @Test
    public void testBitReuse() {
        BitMap<String> bitMap = new BitMap<String>();
        int v1Bit = bitMap.add("v1");
        int v2Bit = bitMap.add("v2");
        int v3Bit = bitMap.add("v3");
        bitMap.remove(v2Bit);
        int v4Bit = bitMap.add("v4");
        Assert.assertEquals((long)v4Bit, (long)v2Bit);
    }
}

