/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.util;

import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.util.JvmPauseMonitor;
import io.hops.hadoop.shaded.org.mockito.Mockito;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class JvmPauseMonitorTest {
    private final Long sleepTime = 100L;
    private final Long infoTH = -1L;
    private final Long warnTH = -1L;
    private JvmPauseMonitor pauseMonitor;

    @Test(timeout=5000L)
    public void testJvmPauseMonitorExceedInfoThreshold() throws InterruptedException {
        QuorumPeerConfig qpConfig = Mockito.mock(QuorumPeerConfig.class);
        Mockito.when(qpConfig.getJvmPauseSleepTimeMs()).thenReturn(this.sleepTime);
        Mockito.when(qpConfig.getJvmPauseInfoThresholdMs()).thenReturn(this.infoTH);
        this.pauseMonitor = new JvmPauseMonitor(qpConfig);
        this.pauseMonitor.serviceStart();
        Assert.assertEquals((Object)this.sleepTime, (Object)this.pauseMonitor.sleepTimeMs);
        Assert.assertEquals((Object)this.infoTH, (Object)this.pauseMonitor.infoThresholdMs);
        while (this.pauseMonitor.getNumGcInfoThresholdExceeded() == 0L) {
            Thread.sleep(200L);
        }
    }

    @Test(timeout=5000L)
    public void testJvmPauseMonitorExceedWarnThreshold() throws InterruptedException {
        QuorumPeerConfig qpConfig = Mockito.mock(QuorumPeerConfig.class);
        Mockito.when(qpConfig.getJvmPauseSleepTimeMs()).thenReturn(this.sleepTime);
        Mockito.when(qpConfig.getJvmPauseWarnThresholdMs()).thenReturn(this.warnTH);
        this.pauseMonitor = new JvmPauseMonitor(qpConfig);
        this.pauseMonitor.serviceStart();
        Assert.assertEquals((Object)this.sleepTime, (Object)this.pauseMonitor.sleepTimeMs);
        Assert.assertEquals((Object)this.warnTH, (Object)this.pauseMonitor.warnThresholdMs);
        while (this.pauseMonitor.getNumGcWarnThresholdExceeded() == 0L) {
            Thread.sleep(200L);
        }
    }

    @After
    public void teardown() {
        this.pauseMonitor.serviceStop();
    }
}

