/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.util;

import io.hops.hadoop.shaded.org.apache.zookeeper.server.util.MessageTracker;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageTrackerTest {
    private static final int BUFFERED_MESSAGE_SIZE = 5;
    private static final Logger LOG = LoggerFactory.getLogger(MessageTrackerTest.class);

    @Before
    public void setup() {
        System.setProperty("zookeeper.messageTracker.Enabled", "true");
    }

    @After
    public void tearDown() throws Exception {
        System.clearProperty("zookeeper.messageTracker.Enabled");
    }

    @Test
    public void testTrackSend() throws InterruptedException {
        long timestamp1 = System.currentTimeMillis();
        MessageTracker messageTracker = new MessageTracker(5);
        messageTracker.trackSent(timestamp1);
        Assert.assertEquals((long)messageTracker.peekSentTimestamp(), (long)timestamp1);
        Thread.sleep(2L);
        long timestamp2 = System.currentTimeMillis();
        messageTracker.trackSent(timestamp2);
        Assert.assertEquals((long)messageTracker.peekSentTimestamp(), (long)timestamp1);
    }

    @Test
    public void testTrackReceived() throws InterruptedException {
        long timestamp1 = System.currentTimeMillis();
        MessageTracker messageTracker = new MessageTracker(5);
        messageTracker.trackReceived(timestamp1);
        Assert.assertEquals((long)messageTracker.peekReceivedTimestamp(), (long)timestamp1);
        Thread.sleep(2L);
        long timestamp2 = System.currentTimeMillis();
        messageTracker.trackReceived(timestamp2);
        Assert.assertEquals((long)messageTracker.peekReceivedTimestamp(), (long)timestamp1);
    }

    @Test
    public void testMessageTrackerFull() throws InterruptedException {
        MessageTracker messageTracker = new MessageTracker(5);
        long timestampSent = 0L;
        long timestampReceived = 0L;
        for (int i = 0; i <= 5; ++i) {
            if (i == 1) {
                timestampSent = System.currentTimeMillis();
                messageTracker.trackSent(timestampSent);
                Thread.sleep(2L);
                timestampReceived = System.currentTimeMillis();
                messageTracker.trackReceived(timestampReceived);
            } else {
                messageTracker.trackSent(System.currentTimeMillis());
                messageTracker.trackReceived(System.currentTimeMillis());
            }
            Thread.sleep(1L);
        }
        Assert.assertEquals((long)messageTracker.peekSentTimestamp(), (long)timestampSent);
        Assert.assertEquals((long)messageTracker.peekReceivedTimestamp(), (long)timestampReceived);
    }

    @Test
    public void testDumpToLog() {
        long timestamp1 = System.currentTimeMillis();
        MessageTracker messageTracker = new MessageTracker(5);
        String sid = "127.0.0.1";
        messageTracker.dumpToLog(sid);
        Assert.assertNull((Object)messageTracker.peekSent());
        Assert.assertNull((Object)messageTracker.peekReceived());
        messageTracker.trackSent(timestamp1);
        Assert.assertEquals((long)messageTracker.peekSentTimestamp(), (long)timestamp1);
        Assert.assertNull((Object)messageTracker.peekReceived());
        messageTracker.dumpToLog(sid);
        Assert.assertNull((Object)messageTracker.peekSent());
        Assert.assertNull((Object)messageTracker.peekReceived());
        messageTracker.trackSent(timestamp1);
        messageTracker.trackReceived(timestamp1);
        Assert.assertEquals((long)messageTracker.peekSentTimestamp(), (long)timestamp1);
        Assert.assertEquals((long)messageTracker.peekReceivedTimestamp(), (long)timestamp1);
        messageTracker.dumpToLog(sid);
        Assert.assertNull((Object)messageTracker.peekSent());
        Assert.assertNull((Object)messageTracker.peekReceived());
    }
}

