/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.WatchedEvent;
import io.hops.hadoop.shaded.org.apache.zookeeper.Watcher;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.metrics.MetricsUtils;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerMetrics;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.SyncRequestProcessor;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.QuorumUtil;
import io.hops.hadoop.shaded.org.hamcrest.Matcher;
import io.hops.hadoop.shaded.org.hamcrest.number.OrderingComparison;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTxnSnapLogMetricsTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(FileTxnSnapLogMetricsTest.class);
    CountDownLatch allCreatedLatch;

    @Test
    public void testFileTxnSnapLogMetrics() throws Exception {
        SyncRequestProcessor.setSnapCount(100);
        QuorumUtil util = new QuorumUtil(1);
        util.startAll();
        this.allCreatedLatch = new CountDownLatch(1);
        byte[] data = new byte[500];
        ZooKeeper zk = ClientBase.createZKClient(util.getConnString());
        for (int i = 0; i < 150; ++i) {
            zk.create("/path" + i, data, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        if (null == zk.exists("/path149", new MockWatcher())) {
            this.allCreatedLatch.await();
        }
        ServerMetrics.getMetrics().resetAll();
        int leader = util.getLeaderServer();
        util.shutdown(leader);
        util.start(leader);
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        LOG.info("txn loaded during start up {}", values.get("max_startup_txns_loaded"));
        Assert.assertEquals((Object)1L, (Object)values.get("cnt_startup_txns_loaded"));
        Assert.assertThat((Object)((Long)values.get("max_startup_txns_loaded")), (Matcher)OrderingComparison.greaterThan((Comparable)Long.valueOf(0L)));
        Assert.assertEquals((Object)1L, (Object)values.get("cnt_startup_txns_load_time"));
        Assert.assertThat((Object)((Long)values.get("max_startup_txns_load_time")), (Matcher)OrderingComparison.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)));
        Assert.assertEquals((Object)1L, (Object)values.get("cnt_startup_snap_load_time"));
        Assert.assertThat((Object)((Long)values.get("max_startup_snap_load_time")), (Matcher)OrderingComparison.greaterThan((Comparable)Long.valueOf(0L)));
        util.shutdownAll();
    }

    private class MockWatcher
    implements Watcher {
        private MockWatcher() {
        }

        @Override
        public void process(WatchedEvent e) {
            LOG.info("all nodes created");
            FileTxnSnapLogMetricsTest.this.allCreatedLatch.countDown();
        }
    }
}

