/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.FileTxnLog;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.TxnLog;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.util.LogChopper;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.Pair;
import io.hops.hadoop.shaded.org.apache.zookeeper.txn.DeleteTxn;
import io.hops.hadoop.shaded.org.apache.zookeeper.txn.TxnHeader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.junit.Assert;
import org.junit.Test;

public class LogChopperTest
extends ClientBase {
    void rmr(File dir) throws IOException {
        Files.walkFileTree(dir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes a) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    Pair<Long, Long> getFirstLastZxid(File logFile) throws IOException {
        long firstZxid;
        File tmp = LogChopperTest.createTmpDir();
        Files.copy(logFile.toPath(), new File(tmp, "log.0").toPath(), new CopyOption[0]);
        FileTxnLog txnLog = new FileTxnLog(tmp);
        TxnLog.TxnIterator it = txnLog.read(0L);
        long lastZxid = firstZxid = it.getHeader().getZxid();
        while (it.next()) {
            lastZxid = it.getHeader().getZxid();
        }
        txnLog.close();
        this.rmr(tmp);
        return new Pair<Long, Long>(firstZxid, lastZxid);
    }

    @Test
    public void testChopper() throws IOException {
        long clientId = 17L;
        int cxid = 77;
        long zxid = 1000L;
        long time = 1L;
        int type = 2;
        DeleteTxn txn = new DeleteTxn("/foo");
        File tmpDir = LogChopperTest.createTmpDir();
        FileTxnLog txnLog = new FileTxnLog(tmpDir);
        for (int i = 0; i < 100; ++i) {
            TxnHeader hdr = new TxnHeader(clientId, cxid, ++zxid, ++time, type);
            txnLog.append(hdr, txn);
        }
        TxnHeader hdr = new TxnHeader(clientId, cxid, zxid + 10L, ++time, type);
        txnLog.append(hdr, txn);
        txnLog.commit();
        File logFile = new File(tmpDir, "log." + Integer.toHexString(1001));
        Pair<Long, Long> firstLast = this.getFirstLastZxid(logFile);
        Assert.assertEquals((long)1001L, (long)firstLast.getFirst());
        Assert.assertEquals((long)1110L, (long)firstLast.getSecond());
        File choppedFile = new File(tmpDir, "chopped_failed");
        Assert.assertFalse((boolean)LogChopper.chop(new FileInputStream(logFile), new FileOutputStream(choppedFile), 1107L));
        choppedFile = new File(tmpDir, "chopped");
        Assert.assertTrue((boolean)LogChopper.chop(new FileInputStream(logFile), new FileOutputStream(choppedFile), 1017L));
        firstLast = this.getFirstLastZxid(choppedFile);
        Assert.assertEquals((long)1001L, (long)firstLast.getFirst());
        Assert.assertEquals((long)1017L, (long)firstLast.getSecond());
    }
}

