/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.glassfish.grizzly.servlet;

import io.hops.hadoop.shaded.javax.servlet.Servlet;
import io.hops.hadoop.shaded.javax.servlet.ServletConfig;
import io.hops.hadoop.shaded.javax.servlet.ServletException;
import io.hops.hadoop.shaded.javax.servlet.ServletRequest;
import io.hops.hadoop.shaded.javax.servlet.ServletResponse;
import io.hops.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Grizzly;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.Cookie;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.Note;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.server.AfterServiceListener;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.server.HttpHandler;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.server.Request;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.server.Response;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.server.util.ClassLoaderUtil;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.server.util.DispatcherHelper;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.server.util.MappingData;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.util.CharChunk;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.util.HttpRequestURIDecoder;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.util.HttpStatus;
import io.hops.hadoop.shaded.org.glassfish.grizzly.servlet.DispatcherType;
import io.hops.hadoop.shaded.org.glassfish.grizzly.servlet.ExpectationHandler;
import io.hops.hadoop.shaded.org.glassfish.grizzly.servlet.FilterChainFactory;
import io.hops.hadoop.shaded.org.glassfish.grizzly.servlet.FilterChainImpl;
import io.hops.hadoop.shaded.org.glassfish.grizzly.servlet.FilterChainInvoker;
import io.hops.hadoop.shaded.org.glassfish.grizzly.servlet.HttpServletRequestImpl;
import io.hops.hadoop.shaded.org.glassfish.grizzly.servlet.HttpServletResponseImpl;
import io.hops.hadoop.shaded.org.glassfish.grizzly.servlet.ServletConfigImpl;
import io.hops.hadoop.shaded.org.glassfish.grizzly.servlet.WebappContext;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServletHandler
extends HttpHandler {
    private static final Logger LOGGER = Grizzly.logger(ServletHandler.class);
    static final Note<HttpServletRequestImpl> SERVLET_REQUEST_NOTE = Request.createNote(HttpServletRequestImpl.class.getName());
    static final Note<HttpServletResponseImpl> SERVLET_RESPONSE_NOTE = Request.createNote(HttpServletResponseImpl.class.getName());
    static final ServletAfterServiceListener servletAfterServiceListener = new ServletAfterServiceListener();
    protected String servletClassName;
    protected Class<? extends Servlet> servletClass;
    protected volatile Servlet servletInstance = null;
    private String contextPath = "";
    private final Object lock = new Object();
    private final WebappContext servletCtx;
    private ServletConfigImpl servletConfig;
    protected final Map<String, Object> properties = new HashMap<String, Object>();
    protected boolean initialize = true;
    protected ClassLoader classLoader;
    protected ExpectationHandler expectationHandler;
    private FilterChainFactory filterChainFactory;
    private List<Runnable> onDestroyListeners;

    protected ServletHandler(ServletConfigImpl servletConfig) {
        this.servletConfig = servletConfig;
        this.servletCtx = (WebappContext)servletConfig.getServletContext();
    }

    @Override
    public void start() {
        try {
            this.configureServletEnv();
            if (this.initialize) {
                this.configureClassLoader(new File(this.servletCtx.getBasePath()).getCanonicalPath());
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "start", t);
        }
    }

    protected void configureClassLoader(String applicationPath) throws IOException {
        if (this.classLoader == null) {
            this.classLoader = ClassLoaderUtil.createURLClassLoader(applicationPath);
        }
    }

    @Override
    protected boolean sendAcknowledgment(Request request, Response response) throws IOException {
        if (this.expectationHandler == null) {
            return super.sendAcknowledgment(request, response);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void service(Request request, Response response) throws Exception {
        if (this.classLoader != null) {
            ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoader);
            try {
                this.doServletService(request, response);
            }
            finally {
                Thread.currentThread().setContextClassLoader(prevClassLoader);
            }
        } else {
            this.doServletService(request, response);
        }
    }

    protected void doServletService(Request request, Response response) {
        try {
            FilterChainInvoker filterChain;
            String uri = request.getRequestURI();
            if (this.contextPath.length() > 0 && !uri.startsWith(this.contextPath)) {
                this.customizeErrorPage(response, "Resource Not Found", 404);
                return;
            }
            HttpServletRequestImpl servletRequest = HttpServletRequestImpl.create();
            HttpServletResponseImpl servletResponse = HttpServletResponseImpl.create();
            this.setPathData(request, servletRequest);
            servletRequest.initialize(request, this.servletCtx);
            servletResponse.initialize(response);
            request.setNote(SERVLET_REQUEST_NOTE, servletRequest);
            request.setNote(SERVLET_RESPONSE_NOTE, servletResponse);
            request.addAfterServiceListener(servletAfterServiceListener);
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                for (Cookie c : cookies) {
                    if (!"JSESSIONID".equals(c.getName())) continue;
                    request.setRequestedSessionId(c.getValue());
                    request.setRequestedSessionCookie(true);
                    break;
                }
            }
            this.loadServlet();
            servletRequest.initSession();
            this.setDispatcherPath(request, this.getCombinedPath(servletRequest));
            servletResponse.addHeader("server", "grizzly/" + Grizzly.getDotedVersion());
            if (this.expectationHandler != null) {
                AckActionImpl ackAction = new AckActionImpl(response);
                this.expectationHandler.onExpectAcknowledgement(servletRequest, servletResponse, ackAction);
                if (!ackAction.isAcknowledged()) {
                    ackAction.acknowledge();
                } else if (ackAction.isFailAcknowledgement()) {
                    return;
                }
            }
            if ((filterChain = this.getFilterChain(request)) != null) {
                filterChain.invokeFilterChain((ServletRequest)servletRequest, (ServletResponse)servletResponse);
            } else {
                this.servletInstance.service((ServletRequest)servletRequest, (ServletResponse)servletResponse);
            }
        }
        catch (Throwable ex) {
            LOGGER.log(Level.SEVERE, "service exception:", ex);
            this.customizeErrorPage(response, "Internal Error", 500);
        }
    }

    protected FilterChainInvoker getFilterChain(Request request) {
        if (this.filterChainFactory != null) {
            return this.filterChainFactory.createFilterChain(request, this.servletInstance, DispatcherType.REQUEST);
        }
        return null;
    }

    private void setDispatcherPath(Request request, String path) {
        request.setAttribute("io.hops.hadoop.shaded.org.apache.catalina.core.DISPATCHER_REQUEST_PATH", path);
    }

    private String getCombinedPath(HttpServletRequest request) {
        if (request.getServletPath() == null) {
            return null;
        }
        if (request.getPathInfo() == null) {
            return request.getServletPath();
        }
        return request.getServletPath() + request.getPathInfo();
    }

    protected void setPathData(Request from, HttpServletRequestImpl to) {
        MappingData data = from.obtainMappingData();
        to.setServletPath(data.wrapperPath.toString());
        to.setPathInfo(data.pathInfo.toString());
        to.setContextPath(data.contextPath.toString());
    }

    void doServletService(ServletRequest servletRequest, ServletResponse servletResponse, DispatcherType dispatcherType) throws IOException, ServletException {
        try {
            this.loadServlet();
            FilterChainImpl filterChain = this.filterChainFactory.createFilterChain(servletRequest, this.servletInstance, dispatcherType);
            if (filterChain != null) {
                filterChain.invokeFilterChain(servletRequest, servletResponse);
            } else {
                this.servletInstance.service(servletRequest, servletResponse);
            }
        }
        catch (ServletException se) {
            LOGGER.log(Level.SEVERE, "service exception:", se);
            throw se;
        }
        catch (IOException ie) {
            LOGGER.log(Level.SEVERE, "service exception:", ie);
            throw ie;
        }
    }

    public void customizeErrorPage(Response response, String message, int errorCode) {
        response.setStatus(errorCode, message);
        response.setContentType("text/html");
        try {
            response.getWriter().write("<html><body><h1>" + message + "</h1></body></html>");
            response.getWriter().flush();
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadServlet() throws ServletException {
        if (this.servletInstance == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.servletInstance == null) {
                    if (this.servletClassName != null) {
                        this.servletInstance = (Servlet)ClassLoaderUtil.load(this.servletClassName);
                    } else {
                        try {
                            this.servletInstance = this.servletClass.newInstance();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    LOGGER.log(Level.INFO, "Loading Servlet: {0}", this.servletInstance.getClass().getName());
                    this.servletInstance.init((ServletConfig)this.servletConfig);
                }
            }
        }
    }

    protected void configureServletEnv() throws ServletException {
        if (this.contextPath.length() > 0) {
            CharChunk cc = new CharChunk();
            char[] ch = this.contextPath.toCharArray();
            cc.setChars(ch, 0, ch.length);
            HttpRequestURIDecoder.normalizeChars(cc);
            this.contextPath = cc.toString();
        }
        if ("".equals(this.contextPath)) {
            this.contextPath = "";
        }
    }

    public Servlet getServletInstance() {
        return this.servletInstance;
    }

    protected void setServletInstance(Servlet servletInstance) {
        this.servletInstance = servletInstance;
    }

    protected void setServletClassName(String servletClassName) {
        this.servletClassName = servletClassName;
    }

    protected void setServletClass(Class<? extends Servlet> servletClass) {
        this.servletClass = servletClass;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        block14: {
            try {
                if (this.classLoader != null) {
                    ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(this.classLoader);
                    try {
                        super.destroy();
                        if (this.servletInstance != null) {
                            this.servletInstance.destroy();
                            this.servletInstance = null;
                        }
                        break block14;
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(prevClassLoader);
                    }
                }
                super.destroy();
            }
            finally {
                if (this.onDestroyListeners != null) {
                    for (int i = 0; i < this.onDestroyListeners.size(); ++i) {
                        try {
                            this.onDestroyListeners.get(i).run();
                            continue;
                        }
                        catch (Throwable t) {
                            LOGGER.log(Level.WARNING, "onDestroyListener error", t);
                        }
                    }
                    this.onDestroyListeners = null;
                }
            }
        }
    }

    protected WebappContext getServletCtx() {
        return this.servletCtx;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ServletConfigImpl getServletConfig() {
        return this.servletConfig;
    }

    @Override
    public String getName() {
        return this.servletConfig.getServletName();
    }

    public ExpectationHandler getExpectationHandler() {
        return this.expectationHandler;
    }

    public void setExpectationHandler(ExpectationHandler expectationHandler) {
        this.expectationHandler = expectationHandler;
    }

    @Override
    protected void setDispatcherHelper(DispatcherHelper dispatcherHelper) {
        this.servletCtx.setDispatcherHelper(dispatcherHelper);
    }

    protected void setFilterChainFactory(FilterChainFactory filterChainFactory) {
        this.filterChainFactory = filterChainFactory;
    }

    void addOnDestroyListener(Runnable r) {
        if (this.onDestroyListeners == null) {
            this.onDestroyListeners = new ArrayList<Runnable>(2);
        }
        this.onDestroyListeners.add(r);
    }

    static final class AckActionImpl
    implements ExpectationHandler.AckAction {
        private boolean isAcknowledged;
        private boolean isFailAcknowledgement;
        private final Response response;

        private AckActionImpl(Response response) {
            this.response = response;
        }

        @Override
        public void acknowledge() throws IOException {
            if (this.isAcknowledged) {
                throw new IllegalStateException("Already acknowledged");
            }
            this.isAcknowledged = true;
            this.response.setStatus(HttpStatus.CONINTUE_100);
            this.response.sendAcknowledgement();
        }

        @Override
        public void fail() throws IOException {
            if (this.isAcknowledged) {
                throw new IllegalStateException("Already acknowledged");
            }
            this.isAcknowledged = true;
            this.isFailAcknowledgement = true;
            this.response.setStatus(HttpStatus.EXPECTATION_FAILED_417);
            this.response.finish();
        }

        public boolean isAcknowledged() {
            return this.isAcknowledged;
        }

        public boolean isFailAcknowledgement() {
            return this.isFailAcknowledgement;
        }
    }

    static final class ServletAfterServiceListener
    implements AfterServiceListener {
        ServletAfterServiceListener() {
        }

        @Override
        public void onAfterService(Request request) {
            HttpServletRequestImpl servletRequest = request.getNote(SERVLET_REQUEST_NOTE);
            HttpServletResponseImpl servletResponse = request.getNote(SERVLET_RESPONSE_NOTE);
            if (servletRequest != null) {
                servletRequest.recycle();
                servletResponse.recycle();
            }
        }
    }
}

