/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.common;

import io.hops.hadoop.shaded.org.apache.zookeeper.common.PathTrie;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PathTrieTest {
    private PathTrie pathTrie;

    @Before
    public void before() {
        this.pathTrie = new PathTrie();
    }

    @Test(expected=NullPointerException.class)
    public void addNullPath() {
        this.pathTrie.addPath(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void addIllegalPath() {
        this.pathTrie.addPath("");
    }

    @Test
    public void addPathToRoot() {
        this.pathTrie.addPath("node1");
        Assert.assertTrue((boolean)this.pathTrie.existsNode("/node1"));
    }

    @Test
    public void addPathToRootLeaves() {
        this.pathTrie.addPath("node1");
        this.pathTrie.addPath("node1/node2");
        this.pathTrie.addPath("node1/node3");
        Assert.assertTrue((boolean)this.pathTrie.existsNode("/node1"));
        Assert.assertTrue((boolean)this.pathTrie.existsNode("/node1/node2"));
        Assert.assertTrue((boolean)this.pathTrie.existsNode("/node1/node3"));
    }

    @Test(expected=NullPointerException.class)
    public void deleteNullPath() {
        this.pathTrie.deletePath(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void deleteIllegalPath() {
        this.pathTrie.deletePath("");
    }

    @Test
    public void deletePathFromRoot() {
        this.pathTrie.addPath("node1");
        this.pathTrie.deletePath("node1");
        Assert.assertFalse((boolean)this.pathTrie.existsNode("/node1"));
    }

    @Test
    public void deletePathFromRootLeaves() {
        this.pathTrie.addPath("node1");
        this.pathTrie.addPath("node1/node2");
        this.pathTrie.addPath("node1/node3");
        this.pathTrie.deletePath("node1/node3");
        Assert.assertTrue((boolean)this.pathTrie.existsNode("/node1"));
        Assert.assertTrue((boolean)this.pathTrie.existsNode("/node1/node2"));
        Assert.assertFalse((boolean)this.pathTrie.existsNode("/node1/node3"));
        this.pathTrie.deletePath("node1/node2");
        Assert.assertTrue((boolean)this.pathTrie.existsNode("/node1"));
        Assert.assertFalse((boolean)this.pathTrie.existsNode("/node1/node2"));
        this.pathTrie.deletePath("node1");
        Assert.assertFalse((boolean)this.pathTrie.existsNode("/node1"));
    }

    @Test
    public void deletePathDoesNotExist() {
        this.pathTrie.addPath("node1");
        this.pathTrie.addPath("node1/node2");
        this.pathTrie.deletePath("node1/node3");
        Assert.assertTrue((boolean)this.pathTrie.existsNode("/node1"));
        Assert.assertTrue((boolean)this.pathTrie.existsNode("/node1/node2"));
    }

    @Test
    public void deleteRootPath() {
        this.pathTrie.addPath("node1");
        this.pathTrie.addPath("node1/node2");
        this.pathTrie.addPath("node1/node3");
        this.pathTrie.deletePath("node1");
        Assert.assertTrue((boolean)this.pathTrie.existsNode("/node1"));
        Assert.assertTrue((boolean)this.pathTrie.existsNode("/node1/node2"));
        Assert.assertTrue((boolean)this.pathTrie.existsNode("/node1/node3"));
    }

    @Test(expected=NullPointerException.class)
    public void findMaxPrefixNullPath() {
        this.pathTrie.findMaxPrefix(null);
    }

    @Test
    public void findMaxPrefixRootPath() {
        Assert.assertEquals((Object)"/", (Object)this.pathTrie.findMaxPrefix("/"));
    }

    @Test
    public void findMaxPrefixChildren() {
        this.pathTrie.addPath("node1");
        this.pathTrie.addPath("node1/node2");
        this.pathTrie.addPath("node1/node3");
        Assert.assertEquals((Object)"/node1", (Object)this.pathTrie.findMaxPrefix("/node1"));
        Assert.assertEquals((Object)"/node1/node2", (Object)this.pathTrie.findMaxPrefix("/node1/node2"));
        Assert.assertEquals((Object)"/node1/node3", (Object)this.pathTrie.findMaxPrefix("/node1/node3"));
    }

    @Test
    public void findMaxPrefixChildrenPrefix() {
        this.pathTrie.addPath("node1");
        Assert.assertEquals((Object)"/node1", (Object)this.pathTrie.findMaxPrefix("/node1/node2"));
        Assert.assertEquals((Object)"/node1", (Object)this.pathTrie.findMaxPrefix("/node1/node3"));
    }
}

