/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum;

import io.hops.hadoop.shaded.org.apache.zookeeper.AsyncCallback;
import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class CloseSessionTxnTest
extends QuorumPeerTestBase {
    @Test
    public void testCloseSessionTxnCompatile() throws Exception {
        this.testCloseSessionWithDifferentConfig(false, false);
        this.testCloseSessionWithDifferentConfig(false, true);
        this.testCloseSessionWithDifferentConfig(true, false);
        this.testCloseSessionWithDifferentConfig(true, true);
    }

    private void testCloseSessionWithDifferentConfig(boolean closeSessionEnabledOnLeader, boolean closeSessionEnabledOnFollower) throws Exception {
        int numServers = 3;
        this.servers = this.LaunchServers(3);
        int leaderId = this.servers.findLeader();
        ZooKeeperServer.setCloseSessionTxnEnabled(closeSessionEnabledOnLeader);
        int followerA = (leaderId + 1) % 3;
        this.servers.mt[followerA].shutdown();
        CloseSessionTxnTest.waitForOne(this.servers.zk[followerA], ZooKeeper.States.CONNECTING);
        String path = "/testCloseSessionTxnCompatile";
        this.servers.zk[leaderId].create(path, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        this.servers.restartClient(leaderId, this);
        CloseSessionTxnTest.waitForOne(this.servers.zk[leaderId], ZooKeeper.States.CONNECTED);
        System.setProperty("zookeeper.retainZKDatabase", "true");
        ZooKeeperServer.setCloseSessionTxnEnabled(closeSessionEnabledOnFollower);
        this.servers.mt[followerA].start();
        CloseSessionTxnTest.waitForOne(this.servers.zk[followerA], ZooKeeper.States.CONNECTED);
        for (int i = 0; i < 3; ++i) {
            final CountDownLatch syncedLatch = new CountDownLatch(1);
            this.servers.zk[i].sync(path, new AsyncCallback.VoidCallback(){

                @Override
                public void processResult(int rc, String path, Object ctx) {
                    syncedLatch.countDown();
                }
            }, null);
            Assert.assertTrue((boolean)syncedLatch.await(3L, TimeUnit.SECONDS));
            Assert.assertNull((Object)this.servers.zk[i].exists(path, false));
        }
    }
}

