/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.client.ConnectStringParser;
import org.junit.Assert;
import org.junit.Test;

public class ConnectStringParserTest
extends ZKTestCase {
    private static final int DEFAULT_PORT = 2181;

    @Test
    public void testSingleServerChrootPath() {
        String chrootPath = "/hallo/welt";
        String servers = "10.10.10.1";
        this.assertChrootPath(chrootPath, new ConnectStringParser(servers + chrootPath));
        servers = "[2001:db8:1::242:ac11:2]";
        this.assertChrootPath(chrootPath, new ConnectStringParser(servers + chrootPath));
    }

    @Test
    public void testMultipleServersChrootPath() {
        String chrootPath = "/hallo/welt";
        String servers = "10.10.10.1,10.10.10.2";
        this.assertChrootPath(chrootPath, new ConnectStringParser(servers + chrootPath));
        servers = "[2001:db8:1::242:ac11:2]:2181,[2001:db8:85a3:8d3:1319:8a2e:370:7348]:5678";
        this.assertChrootPath(chrootPath, new ConnectStringParser(servers + chrootPath));
    }

    @Test
    public void testParseServersWithoutPort() {
        String servers = "10.10.10.1,10.10.10.2";
        ConnectStringParser parser = new ConnectStringParser(servers);
        Assert.assertEquals((Object)"10.10.10.1", (Object)parser.getServerAddresses().get(0).getHostString());
        Assert.assertEquals((long)2181L, (long)parser.getServerAddresses().get(0).getPort());
        Assert.assertEquals((Object)"10.10.10.2", (Object)parser.getServerAddresses().get(1).getHostString());
        Assert.assertEquals((long)2181L, (long)parser.getServerAddresses().get(1).getPort());
        servers = "[2001:db8:1::242:ac11:2],[2001:db8:85a3:8d3:1319:8a2e:370:7348]";
        parser = new ConnectStringParser(servers);
        Assert.assertEquals((Object)"2001:db8:1::242:ac11:2", (Object)parser.getServerAddresses().get(0).getHostString());
        Assert.assertEquals((long)2181L, (long)parser.getServerAddresses().get(0).getPort());
        Assert.assertEquals((Object)"2001:db8:85a3:8d3:1319:8a2e:370:7348", (Object)parser.getServerAddresses().get(1).getHostString());
        Assert.assertEquals((long)2181L, (long)parser.getServerAddresses().get(1).getPort());
    }

    @Test
    public void testParseServersWithPort() {
        String servers = "10.10.10.1:112,10.10.10.2:110";
        ConnectStringParser parser = new ConnectStringParser(servers);
        Assert.assertEquals((Object)"10.10.10.1", (Object)parser.getServerAddresses().get(0).getHostString());
        Assert.assertEquals((Object)"10.10.10.2", (Object)parser.getServerAddresses().get(1).getHostString());
        Assert.assertEquals((long)112L, (long)parser.getServerAddresses().get(0).getPort());
        Assert.assertEquals((long)110L, (long)parser.getServerAddresses().get(1).getPort());
        servers = "[2001:db8:1::242:ac11:2]:1234,[2001:db8:85a3:8d3:1319:8a2e:370:7348]:5678";
        parser = new ConnectStringParser(servers);
        Assert.assertEquals((Object)"2001:db8:1::242:ac11:2", (Object)parser.getServerAddresses().get(0).getHostString());
        Assert.assertEquals((Object)"2001:db8:85a3:8d3:1319:8a2e:370:7348", (Object)parser.getServerAddresses().get(1).getHostString());
        Assert.assertEquals((long)1234L, (long)parser.getServerAddresses().get(0).getPort());
        Assert.assertEquals((long)5678L, (long)parser.getServerAddresses().get(1).getPort());
    }

    private void assertChrootPath(String expected, ConnectStringParser parser) {
        Assert.assertEquals((Object)expected, (Object)parser.getChrootPath());
    }

    @Test
    public void testParseIPV6ConnectionString() {
        String servers = "[127::1],127.0.10.2";
        ConnectStringParser parser = new ConnectStringParser(servers);
        Assert.assertEquals((Object)"127::1", (Object)parser.getServerAddresses().get(0).getHostString());
        Assert.assertEquals((Object)"127.0.10.2", (Object)parser.getServerAddresses().get(1).getHostString());
        Assert.assertEquals((long)2181L, (long)parser.getServerAddresses().get(0).getPort());
        Assert.assertEquals((long)2181L, (long)parser.getServerAddresses().get(1).getPort());
        servers = "[127::1]:2181,[127::2]:2182,[127::3]:2183";
        parser = new ConnectStringParser(servers);
        Assert.assertEquals((Object)"127::1", (Object)parser.getServerAddresses().get(0).getHostString());
        Assert.assertEquals((Object)"127::2", (Object)parser.getServerAddresses().get(1).getHostString());
        Assert.assertEquals((Object)"127::3", (Object)parser.getServerAddresses().get(2).getHostString());
        Assert.assertEquals((long)2181L, (long)parser.getServerAddresses().get(0).getPort());
        Assert.assertEquals((long)2182L, (long)parser.getServerAddresses().get(1).getPort());
        Assert.assertEquals((long)2183L, (long)parser.getServerAddresses().get(2).getPort());
    }
}

