/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.glassfish.grizzly.servlet;

import io.hops.hadoop.shaded.javax.servlet.RequestDispatcher;
import io.hops.hadoop.shaded.javax.servlet.ServletContext;
import io.hops.hadoop.shaded.javax.servlet.ServletInputStream;
import io.hops.hadoop.shaded.javax.servlet.ServletRequest;
import io.hops.hadoop.shaded.javax.servlet.ServletRequestAttributeEvent;
import io.hops.hadoop.shaded.javax.servlet.ServletRequestAttributeListener;
import io.hops.hadoop.shaded.javax.servlet.http.Cookie;
import io.hops.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import io.hops.hadoop.shaded.javax.servlet.http.HttpSession;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Grizzly;
import io.hops.hadoop.shaded.org.glassfish.grizzly.ThreadCache;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.server.Request;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.server.Session;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.server.util.Enumerator;
import io.hops.hadoop.shaded.org.glassfish.grizzly.localization.LogMessages;
import io.hops.hadoop.shaded.org.glassfish.grizzly.servlet.CookieWrapper;
import io.hops.hadoop.shaded.org.glassfish.grizzly.servlet.Holders;
import io.hops.hadoop.shaded.org.glassfish.grizzly.servlet.HttpSessionImpl;
import io.hops.hadoop.shaded.org.glassfish.grizzly.servlet.ServletInputStreamImpl;
import io.hops.hadoop.shaded.org.glassfish.grizzly.servlet.ServletReaderImpl;
import io.hops.hadoop.shaded.org.glassfish.grizzly.servlet.WebappContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpServletRequestImpl
implements HttpServletRequest,
Holders.RequestHolder {
    private static final Logger logger = Grizzly.logger(HttpServletRequestImpl.class);
    private final ServletInputStreamImpl inputStream = new ServletInputStreamImpl();
    private ServletReaderImpl reader;
    private HttpSessionImpl httpSession = null;
    private WebappContext contextImpl;
    private String contextPath = "";
    private String servletPath = "";
    private String pathInfo;
    protected boolean usingInputStream = false;
    protected boolean usingReader = false;
    private static final ThreadCache.CachedTypeIndex<HttpServletRequestImpl> CACHE_IDX = ThreadCache.obtainIndex(HttpServletRequestImpl.class, 2);
    protected Request request = null;

    public static HttpServletRequestImpl create() {
        HttpServletRequestImpl request = ThreadCache.takeFromCache(CACHE_IDX);
        if (request != null) {
            return request;
        }
        return new HttpServletRequestImpl();
    }

    protected HttpServletRequestImpl() {
    }

    public void initialize(Request request, WebappContext context) throws IOException {
        this.request = request;
        request.getInputBuffer().setAsyncEnabled(false);
        this.inputStream.initialize(request);
        this.contextImpl = context;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public Object getAttribute(String name) {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new GetAttributePrivilegedAction());
        }
        return new Enumerator<String>((Collection<String>)this.request.getAttributeNames());
    }

    public String getCharacterEncoding() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new GetCharacterEncodingPrivilegedAction());
        }
        return this.request.getCharacterEncoding();
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        this.request.setCharacterEncoding(env);
    }

    public int getContentLength() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getContentLength();
    }

    public String getContentType() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.usingReader) {
            throw new IllegalStateException("Illegal attempt to call getInputStream() after getReader() has already been called.");
        }
        this.usingInputStream = true;
        return this.inputStream;
    }

    void recycle() {
        this.request = null;
        this.reader = null;
        this.inputStream.recycle();
        this.usingInputStream = false;
        this.usingReader = false;
    }

    public String getParameter(String name) {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new GetParameterPrivilegedAction(name));
        }
        return this.request.getParameter(name);
    }

    public Enumeration getParameterNames() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            return new Enumerator(AccessController.doPrivileged(new GetParameterNamesPrivilegedAction()));
        }
        return new Enumerator<String>((Collection<String>)this.request.getParameterNames());
    }

    public String[] getParameterValues(String name) {
        String[] ret;
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            ret = AccessController.doPrivileged(new GetParameterValuePrivilegedAction(name));
            if (ret != null) {
                ret = (String[])ret.clone();
            }
        } else {
            ret = this.request.getParameterValues(name);
        }
        return ret;
    }

    public Map getParameterMap() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new GetParameterMapPrivilegedAction());
        }
        return this.request.getParameterMap();
    }

    public String getProtocol() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getProtocol().getProtocolString();
    }

    public String getScheme() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getScheme();
    }

    public String getServerName() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getServerName();
    }

    public int getServerPort() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getServerPort();
    }

    public BufferedReader getReader() throws IOException {
        if (this.usingInputStream) {
            throw new IllegalStateException("Illegal attempt to call getReader() after getInputStream() has already been called.");
        }
        this.usingReader = true;
        if (this.reader == null) {
            this.reader = new ServletReaderImpl(this.request.getReader());
        }
        return this.reader;
    }

    public String getRemoteAddr() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getRemoteAddr();
    }

    public String getRemoteHost() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getRemoteHost();
    }

    public void setAttribute(String name, Object value) {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        Object oldValue = this.request.getAttribute(name);
        this.request.setAttribute(name, value);
        EventListener[] listeners = this.contextImpl.getEventListeners();
        if (listeners.length == 0) {
            return;
        }
        ServletRequestAttributeEvent event = null;
        int len = listeners.length;
        for (int i = 0; i < len; ++i) {
            if (!(listeners[i] instanceof ServletRequestAttributeListener)) continue;
            ServletRequestAttributeListener listener = (ServletRequestAttributeListener)listeners[i];
            try {
                if (event == null) {
                    event = oldValue != null ? new ServletRequestAttributeEvent((ServletContext)this.contextImpl, (ServletRequest)this, name, oldValue) : new ServletRequestAttributeEvent((ServletContext)this.contextImpl, (ServletRequest)this, name, value);
                }
                if (oldValue != null) {
                    listener.attributeReplaced(event);
                    continue;
                }
                listener.attributeAdded(event);
                continue;
            }
            catch (Throwable t) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_ATTRIBUTE_LISTENER_ADD_ERROR("ServletRequestAttributeListener", listener.getClass().getName()), t);
            }
        }
    }

    public void removeAttribute(String name) {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        Object value = this.request.getAttribute(name);
        this.request.removeAttribute(name);
        EventListener[] listeners = this.contextImpl.getEventListeners();
        if (listeners.length == 0) {
            return;
        }
        ServletRequestAttributeEvent event = null;
        int len = listeners.length;
        for (int i = 0; i < len; ++i) {
            if (!(listeners[i] instanceof ServletRequestAttributeListener)) continue;
            ServletRequestAttributeListener listener = (ServletRequestAttributeListener)listeners[i];
            try {
                if (event == null) {
                    event = new ServletRequestAttributeEvent((ServletContext)this.contextImpl, (ServletRequest)this, name, value);
                }
                listener.attributeRemoved(event);
                continue;
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_ATTRIBUTE_LISTENER_REMOVE_ERROR("ServletRequestAttributeListener", listener.getClass().getName()), t);
            }
        }
    }

    public Locale getLocale() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new GetLocalePrivilegedAction());
        }
        return this.request.getLocale();
    }

    public Enumeration getLocales() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new GetLocalesPrivilegedAction());
        }
        return new Enumerator<Locale>((Collection<Locale>)this.request.getLocales());
    }

    public boolean isSecure() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new GetRequestDispatcherPrivilegedAction(path));
        }
        return this.getRequestDispatcherInternal(path);
    }

    private RequestDispatcher getRequestDispatcherInternal(String path) {
        if (this.contextImpl == null) {
            return null;
        }
        if (path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            return this.contextImpl.getRequestDispatcher(path);
        }
        String servletPath = (String)this.getAttribute("io.hops.hadoop.shaded.javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = this.getServletPath();
        }
        String pathInfo = this.getPathInfo();
        String requestPath = null;
        requestPath = pathInfo == null ? servletPath : servletPath + pathInfo;
        int pos = requestPath.lastIndexOf(47);
        String relative = null;
        relative = pos >= 0 ? requestPath.substring(0, pos + 1) + path : requestPath + path;
        return this.contextImpl.getRequestDispatcher(relative);
    }

    public String getRealPath(String path) {
        return this.contextImpl.getRealPath(path);
    }

    public String getAuthType() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getAuthType();
    }

    public io.hops.hadoop.shaded.org.glassfish.grizzly.http.Cookie[] getGrizzlyCookies() {
        io.hops.hadoop.shaded.org.glassfish.grizzly.http.Cookie[] ret;
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            ret = AccessController.doPrivileged(new GetCookiesPrivilegedAction());
            if (ret != null) {
                ret = (io.hops.hadoop.shaded.org.glassfish.grizzly.http.Cookie[])ret.clone();
            }
        } else {
            ret = this.request.getCookies();
        }
        return ret;
    }

    public long getDateHeader(String name) {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getDateHeader(name);
    }

    public String getHeader(String name) {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getHeader(name);
    }

    public Enumeration getHeaders(String name) {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new GetHeadersPrivilegedAction(name));
        }
        return new Enumerator<String>(this.request.getHeaders(name).iterator());
    }

    public Enumeration getHeaderNames() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new GetHeaderNamesPrivilegedAction());
        }
        return new Enumerator<String>(this.request.getHeaderNames().iterator());
    }

    public int getIntHeader(String name) {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getIntHeader(name);
    }

    public String getMethod() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getMethod().getMethodString();
    }

    public String getPathInfo() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.pathInfo;
    }

    public String getPathTranslated() {
        if (this.getPathInfo() == null) {
            return null;
        }
        return this.contextImpl.getRealPath(this.getPathInfo());
    }

    public String getContextPath() {
        return this.contextPath;
    }

    protected void setContextPath(String contextPath) {
        if (contextPath == null) {
            this.contextPath = "";
        }
        this.contextPath = contextPath;
    }

    public String getQueryString() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getQueryString();
    }

    public String getRemoteUser() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getRemoteUser();
    }

    public boolean isUserInRole(String role) {
        throw new IllegalStateException("Not yet implemented");
    }

    public Principal getUserPrincipal() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getUserPrincipal();
    }

    public String getRequestedSessionId() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getRequestedSessionId();
    }

    public String getRequestURI() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return Request.appendRequestURL(this.request, new StringBuffer());
    }

    public String getServletPath() {
        return this.servletPath;
    }

    protected void initSession() {
        Session session = this.request.getSession(false);
        if (session != null) {
            this.httpSession = new HttpSessionImpl(this.contextImpl);
            this.httpSession.notifyNew();
            this.httpSession.setSession(session);
            this.httpSession.access();
        }
    }

    public HttpSession getSession(boolean create) {
        if (this.httpSession == null && create) {
            this.httpSession = new HttpSessionImpl(this.contextImpl);
        }
        if (this.httpSession != null) {
            Session session = this.request.getSession(create);
            if (session != null) {
                this.httpSession.setSession(session);
                this.httpSession.access();
            } else {
                return null;
            }
        }
        return this.httpSession;
    }

    public HttpSession getSession() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.getSession(true);
    }

    public boolean isRequestedSessionIdValid() {
        return this.request.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.request.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.request.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public Cookie[] getCookies() {
        io.hops.hadoop.shaded.org.glassfish.grizzly.http.Cookie[] internalCookies = this.request.getCookies();
        if (internalCookies == null) {
            return null;
        }
        Cookie[] cookies = new Cookie[internalCookies.length];
        for (int i = 0; i < internalCookies.length; ++i) {
            io.hops.hadoop.shaded.org.glassfish.grizzly.http.Cookie cook = internalCookies[i];
            if (cook instanceof CookieWrapper) {
                cookies[i] = ((CookieWrapper)internalCookies[i]).getWrappedCookie();
                continue;
            }
            cookies[i] = new Cookie(cook.getName(), cook.getValue());
            cookies[i].setComment(cook.getComment());
            if (cook.getDomain() != null) {
                cookies[i].setDomain(cook.getDomain());
            }
            cookies[i].setMaxAge(cook.getMaxAge());
            cookies[i].setPath(cook.getPath());
            cookies[i].setSecure(cook.isSecure());
            cookies[i].setVersion(cook.getVersion());
        }
        return cookies;
    }

    public int getRemotePort() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getRemotePort();
    }

    public String getLocalName() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getLocalName();
    }

    public String getLocalAddr() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getLocalAddr();
    }

    public int getLocalPort() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getLocalPort();
    }

    protected WebappContext getContextImpl() {
        return this.contextImpl;
    }

    protected void setContextImpl(WebappContext contextImpl) {
        this.contextImpl = contextImpl;
    }

    public void setServletPath(String servletPath) {
        if (servletPath != null) {
            this.servletPath = servletPath.length() == 0 ? "" : servletPath;
        }
    }

    protected void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public Request getRequest() {
        return this.request;
    }

    @Override
    public Request getInternalRequest() {
        return this.request;
    }

    private final class GetLocalesPrivilegedAction
    implements PrivilegedAction<Enumeration<Locale>> {
        private GetLocalesPrivilegedAction() {
        }

        @Override
        public Enumeration<Locale> run() {
            return new Enumerator<Locale>((Collection<Locale>)HttpServletRequestImpl.this.request.getLocales());
        }
    }

    private final class GetLocalePrivilegedAction
    implements PrivilegedAction<Locale> {
        private GetLocalePrivilegedAction() {
        }

        @Override
        public Locale run() {
            return HttpServletRequestImpl.this.request.getLocale();
        }
    }

    private final class GetHeaderNamesPrivilegedAction
    implements PrivilegedAction<Enumeration<String>> {
        private GetHeaderNamesPrivilegedAction() {
        }

        @Override
        public Enumeration<String> run() {
            return new Enumerator<String>(HttpServletRequestImpl.this.request.getHeaderNames());
        }
    }

    private final class GetHeadersPrivilegedAction
    implements PrivilegedAction<Enumeration<String>> {
        private final String name;

        public GetHeadersPrivilegedAction(String name) {
            this.name = name;
        }

        @Override
        public Enumeration<String> run() {
            return new Enumerator<String>(HttpServletRequestImpl.this.request.getHeaders(this.name));
        }
    }

    private final class GetCharacterEncodingPrivilegedAction
    implements PrivilegedAction<String> {
        private GetCharacterEncodingPrivilegedAction() {
        }

        @Override
        public String run() {
            return HttpServletRequestImpl.this.request.getCharacterEncoding();
        }
    }

    private final class GetCookiesPrivilegedAction
    implements PrivilegedAction<io.hops.hadoop.shaded.org.glassfish.grizzly.http.Cookie[]> {
        private GetCookiesPrivilegedAction() {
        }

        @Override
        public io.hops.hadoop.shaded.org.glassfish.grizzly.http.Cookie[] run() {
            return HttpServletRequestImpl.this.request.getCookies();
        }
    }

    private final class GetParameterValuePrivilegedAction
    implements PrivilegedAction<String[]> {
        public final String name;

        public GetParameterValuePrivilegedAction(String name) {
            this.name = name;
        }

        @Override
        public String[] run() {
            return HttpServletRequestImpl.this.request.getParameterValues(this.name);
        }
    }

    private final class GetParameterNamesPrivilegedAction
    implements PrivilegedAction<Set<String>> {
        private GetParameterNamesPrivilegedAction() {
        }

        @Override
        public Set<String> run() {
            return HttpServletRequestImpl.this.request.getParameterNames();
        }
    }

    private final class GetParameterPrivilegedAction
    implements PrivilegedAction<String> {
        public final String name;

        public GetParameterPrivilegedAction(String name) {
            this.name = name;
        }

        @Override
        public String run() {
            return HttpServletRequestImpl.this.request.getParameter(this.name);
        }
    }

    private final class GetRequestDispatcherPrivilegedAction
    implements PrivilegedAction<RequestDispatcher> {
        private final String path;

        public GetRequestDispatcherPrivilegedAction(String path) {
            this.path = path;
        }

        @Override
        public RequestDispatcher run() {
            return HttpServletRequestImpl.this.getRequestDispatcherInternal(this.path);
        }
    }

    private final class GetParameterMapPrivilegedAction
    implements PrivilegedAction<Map<String, String[]>> {
        private GetParameterMapPrivilegedAction() {
        }

        @Override
        public Map<String, String[]> run() {
            return HttpServletRequestImpl.this.request.getParameterMap();
        }
    }

    private final class GetAttributePrivilegedAction
    implements PrivilegedAction<Enumeration<String>> {
        private GetAttributePrivilegedAction() {
        }

        @Override
        public Enumeration<String> run() {
            return new Enumerator<String>((Collection<String>)HttpServletRequestImpl.this.request.getAttributeNames());
        }
    }
}

