/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.WatchedEvent;
import io.hops.hadoop.shaded.org.apache.zookeeper.Watcher;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeperMain;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveWatchesCmdTest
extends ClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(RemoveWatchesCmdTest.class);
    private ZooKeeper zk;
    private ZooKeeperMain zkMain;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.zk = this.createClient();
        this.zkMain = new ZooKeeperMain(this.zk);
    }

    @Override
    public void tearDown() throws Exception {
        if (this.zk != null) {
            this.zk.close();
        }
        super.tearDown();
    }

    @Test(timeout=30000L)
    public void testRemoveWatchesWithNoPassedOptions() throws Exception {
        ArrayList<Watcher.Event.EventType> expectedEvents = new ArrayList<Watcher.Event.EventType>();
        expectedEvents.add(Watcher.Event.EventType.ChildWatchRemoved);
        expectedEvents.add(Watcher.Event.EventType.DataWatchRemoved);
        MyWatcher myWatcher = new MyWatcher("/testnode1", expectedEvents, 2);
        this.zk.create("/testnode1", "data".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.create("/testnode2", "data".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        LOG.info("Adding childwatcher to /testnode1 and /testnode2");
        this.zk.getChildren("/testnode1", myWatcher);
        this.zk.getChildren("/testnode2", myWatcher);
        LOG.info("Adding datawatcher to /testnode1 and /testnode2");
        this.zk.getData("/testnode1", myWatcher, null);
        this.zk.getData("/testnode2", myWatcher, null);
        String cmdstring = "removewatches /testnode1";
        LOG.info("Remove watchers using shell command : {}", (Object)cmdstring);
        this.zkMain.cl.parseCommand(cmdstring);
        Assert.assertTrue((String)"Removewatches cmd fails to remove child watches", (boolean)this.zkMain.processZKCmd(this.zkMain.cl));
        LOG.info("Waiting for the DataWatchRemoved event");
        myWatcher.matches();
        Assert.assertTrue((String)"Failed to find child watches for the path testnode2", (boolean)this.zk.getChildWatches().contains("/testnode2"));
        Assert.assertTrue((String)"Failed to find data watches for the path testnode2", (boolean)this.zk.getDataWatches().contains("/testnode2"));
    }

    @Test(timeout=30000L)
    public void testRemoveNodeDataChangedWatches() throws Exception {
        LOG.info("Adding data watcher using getData()");
        ArrayList<Watcher.Event.EventType> expectedEvents = new ArrayList<Watcher.Event.EventType>();
        expectedEvents.add(Watcher.Event.EventType.DataWatchRemoved);
        MyWatcher myWatcher = new MyWatcher("/testnode1", expectedEvents, 1);
        this.zk.create("/testnode1", "data".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.getData("/testnode1", myWatcher, null);
        String cmdstring = "removewatches /testnode1 -d";
        LOG.info("Remove watchers using shell command : {}", (Object)cmdstring);
        this.zkMain.cl.parseCommand(cmdstring);
        Assert.assertTrue((String)"Removewatches cmd fails to remove data watches", (boolean)this.zkMain.processZKCmd(this.zkMain.cl));
        LOG.info("Waiting for the DataWatchRemoved event");
        myWatcher.matches();
        Assert.assertEquals((String)("Data watches are not removed : " + this.zk.getDataWatches()), (long)0L, (long)this.zk.getDataWatches().size());
    }

    @Test(timeout=30000L)
    public void testRemoveNodeCreatedWatches() throws Exception {
        ArrayList<Watcher.Event.EventType> expectedEvents = new ArrayList<Watcher.Event.EventType>();
        expectedEvents.add(Watcher.Event.EventType.DataWatchRemoved);
        MyWatcher myWatcher1 = new MyWatcher("/testnode1", expectedEvents, 1);
        MyWatcher myWatcher2 = new MyWatcher("/testnode1/testnode2", expectedEvents, 1);
        LOG.info("Adding NodeCreated watcher");
        this.zk.exists("/testnode1", myWatcher1);
        this.zk.exists("/testnode1/testnode2", myWatcher2);
        String cmdstring1 = "removewatches /testnode1 -d";
        LOG.info("Remove watchers using shell command : {}", (Object)cmdstring1);
        this.zkMain.cl.parseCommand(cmdstring1);
        Assert.assertTrue((String)"Removewatches cmd fails to remove pre-create watches", (boolean)this.zkMain.processZKCmd(this.zkMain.cl));
        myWatcher1.matches();
        Assert.assertEquals((String)("Failed to remove pre-create watches :" + this.zk.getExistWatches()), (long)1L, (long)this.zk.getExistWatches().size());
        Assert.assertTrue((String)("Failed to remove pre-create watches :" + this.zk.getExistWatches()), (boolean)this.zk.getExistWatches().contains("/testnode1/testnode2"));
        String cmdstring2 = "removewatches /testnode1/testnode2 -d";
        LOG.info("Remove watchers using shell command : {}", (Object)cmdstring2);
        this.zkMain.cl.parseCommand(cmdstring2);
        Assert.assertTrue((String)"Removewatches cmd fails to remove data watches", (boolean)this.zkMain.processZKCmd(this.zkMain.cl));
        myWatcher2.matches();
        Assert.assertEquals((String)("Failed to remove pre-create watches : " + this.zk.getExistWatches()), (long)0L, (long)this.zk.getExistWatches().size());
    }

    @Test(timeout=30000L)
    public void testRemoveNodeChildrenChangedWatches() throws Exception {
        ArrayList<Watcher.Event.EventType> expectedEvents = new ArrayList<Watcher.Event.EventType>();
        expectedEvents.add(Watcher.Event.EventType.ChildWatchRemoved);
        MyWatcher myWatcher = new MyWatcher("/testnode1", expectedEvents, 1);
        this.zk.create("/testnode1", "data".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        LOG.info("Adding child changed watcher");
        this.zk.getChildren("/testnode1", myWatcher);
        String cmdstring = "removewatches /testnode1 -c";
        LOG.info("Remove watchers using shell command : {}", (Object)cmdstring);
        this.zkMain.cl.parseCommand(cmdstring);
        Assert.assertTrue((String)"Removewatches cmd fails to remove child watches", (boolean)this.zkMain.processZKCmd(this.zkMain.cl));
        myWatcher.matches();
        Assert.assertEquals((String)("Failed to remove child watches : " + this.zk.getChildWatches()), (long)0L, (long)this.zk.getChildWatches().size());
    }

    @Test(timeout=30000L)
    public void testRemoveNodeDeletedWatches() throws Exception {
        LOG.info("Adding NodeDeleted watcher");
        ArrayList<Watcher.Event.EventType> expectedEvents = new ArrayList<Watcher.Event.EventType>();
        expectedEvents.add(Watcher.Event.EventType.ChildWatchRemoved);
        expectedEvents.add(Watcher.Event.EventType.NodeDeleted);
        MyWatcher myWatcher = new MyWatcher("/testnode1", expectedEvents, 1);
        this.zk.create("/testnode1", "data".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.create("/testnode1/testnode2", "data".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.getChildren("/testnode1/testnode2", myWatcher);
        this.zk.getChildren("/testnode1", myWatcher);
        String cmdstring = "removewatches /testnode1 -c";
        LOG.info("Remove watchers using shell command : {}", (Object)cmdstring);
        this.zkMain.cl.parseCommand(cmdstring);
        Assert.assertTrue((String)"Removewatches cmd fails to remove child watches", (boolean)this.zkMain.processZKCmd(this.zkMain.cl));
        LOG.info("Waiting for the ChildWatchRemoved event");
        myWatcher.matches();
        Assert.assertEquals((String)("Failed to remove child watches : " + this.zk.getChildWatches()), (long)1L, (long)this.zk.getChildWatches().size());
        Assert.assertTrue((String)("Failed to remove child watches :" + this.zk.getChildWatches()), (boolean)this.zk.getChildWatches().contains("/testnode1/testnode2"));
        this.zk.delete("/testnode1/testnode2", -1);
        myWatcher.matches();
    }

    @Test(timeout=30000L)
    public void testRemoveAnyWatches() throws Exception {
        this.verifyRemoveAnyWatches(false);
    }

    @Test(timeout=30000L)
    public void testRemoveWatchesLocallyWhenNoServerConnection() throws Exception {
        this.verifyRemoveAnyWatches(true);
    }

    private void verifyRemoveAnyWatches(boolean local) throws Exception {
        final HashMap pathVsEvent = new HashMap();
        LOG.info("Adding NodeChildrenChanged, NodeDataChanged watchers");
        final CountDownLatch watcherLatch = new CountDownLatch(2);
        Watcher watcher = new Watcher(){

            @Override
            public void process(WatchedEvent event) {
                switch (event.getType()) {
                    case ChildWatchRemoved: 
                    case DataWatchRemoved: {
                        this.addWatchNotifications(pathVsEvent, event);
                        watcherLatch.countDown();
                        break;
                    }
                    case NodeChildrenChanged: 
                    case NodeDataChanged: {
                        this.addWatchNotifications(pathVsEvent, event);
                    }
                }
            }

            private void addWatchNotifications(Map<String, List<Watcher.Event.EventType>> pathVsEvent2, WatchedEvent event) {
                pathVsEvent2.computeIfAbsent(event.getPath(), k -> new ArrayList()).add(event.getType());
            }
        };
        this.zk.create("/testnode1", "data".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.getChildren("/testnode1", watcher);
        this.zk.getData("/testnode1", watcher, null);
        String cmdstring = "removewatches /testnode1 -a";
        if (local) {
            LOG.info("Stopping ZK server to verify deletion of watches locally");
            this.stopServer();
            cmdstring = "removewatches /testnode1 -a -l";
        }
        LOG.info("Remove watchers using shell command : {}", (Object)cmdstring);
        this.zkMain.cl.parseCommand(cmdstring);
        Assert.assertTrue((String)"Removewatches cmd fails to remove child/data watches", (boolean)this.zkMain.processZKCmd(this.zkMain.cl));
        LOG.info("Waiting for the WatchRemoved events");
        watcherLatch.await(10L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"Didn't receives WatchRemoved events!", (long)1L, (long)pathVsEvent.size());
        Assert.assertTrue((String)"Didn't receives DataWatchRemoved!", (boolean)((List)pathVsEvent.get("/testnode1")).contains((Object)Watcher.Event.EventType.DataWatchRemoved));
        Assert.assertTrue((String)"Didn't receives ChildWatchRemoved!", (boolean)((List)pathVsEvent.get("/testnode1")).contains((Object)Watcher.Event.EventType.ChildWatchRemoved));
    }

    private static class MyWatcher
    implements Watcher {
        private final String path;
        private String eventPath;
        private final CountDownLatch latch;
        private final List<Watcher.Event.EventType> expectedEvents = new ArrayList<Watcher.Event.EventType>();

        MyWatcher(String path, List<Watcher.Event.EventType> expectedEvents, int count) {
            this.path = path;
            this.latch = new CountDownLatch(count);
            this.expectedEvents.addAll(expectedEvents);
        }

        @Override
        public void process(WatchedEvent event) {
            LOG.debug("Event path : {}, eventPath : {}", (Object)this.path, (Object)event.getPath());
            this.eventPath = event.getPath();
            if (this.expectedEvents.contains((Object)event.getType())) {
                this.latch.countDown();
            }
        }

        public boolean matches() throws InterruptedException {
            if (!this.latch.await(ClientBase.CONNECTION_TIMEOUT / 3, TimeUnit.MILLISECONDS)) {
                LOG.error("Failed to get watch notifications!");
                return false;
            }
            LOG.debug("Client path : {} eventPath : {}", (Object)this.path, (Object)this.eventPath);
            return this.path.equals(this.eventPath);
        }
    }
}

