/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import com.google.common.base.Preconditions;
import io.hops.hadoop.shaded.org.hamcrest.Description;
import io.hops.hadoop.shaded.org.mockito.AdditionalMatchers;
import io.hops.hadoop.shaded.org.mockito.ArgumentCaptor;
import io.hops.hadoop.shaded.org.mockito.ArgumentMatcher;
import io.hops.hadoop.shaded.org.mockito.Mockito;
import io.hops.hadoop.shaded.org.mockito.invocation.InvocationOnMock;
import io.hops.hadoop.shaded.org.mockito.stubbing.Answer;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.util.Quantile;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsAsserts {
    static final Logger LOG = LoggerFactory.getLogger(MetricsAsserts.class);
    private static final double EPSILON = 1.0E-5;

    public static MetricsSystem mockMetricsSystem() {
        MetricsSystem ms = Mockito.mock(MetricsSystem.class);
        DefaultMetricsSystem.setInstance((MetricsSystem)ms);
        return ms;
    }

    public static MetricsRecordBuilder mockMetricsRecordBuilder() {
        final MetricsCollector mc = Mockito.mock(MetricsCollector.class);
        MetricsRecordBuilder rb = Mockito.mock(MetricsRecordBuilder.class, new Answer<Object>(){

            @Override
            public Object answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                StringBuilder sb = new StringBuilder();
                for (Object o : args) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(String.valueOf(o));
                }
                String methodName = invocation.getMethod().getName();
                LOG.debug(methodName + ": " + sb);
                return methodName.equals("parent") || methodName.equals("endRecord") ? mc : invocation.getMock();
            }
        });
        Mockito.when(mc.addRecord(Mockito.anyString())).thenReturn(rb);
        Mockito.when(mc.addRecord(MetricsAsserts.anyInfo())).thenReturn(rb);
        return rb;
    }

    public static MetricsRecordBuilder getMetrics(MetricsSource source, boolean all) {
        MetricsRecordBuilder rb = MetricsAsserts.mockMetricsRecordBuilder();
        MetricsCollector mc = rb.parent();
        source.getMetrics(mc, all);
        return rb;
    }

    public static MetricsRecordBuilder getMetrics(String name) {
        return MetricsAsserts.getMetrics(DefaultMetricsSystem.instance().getSource(name));
    }

    public static MetricsRecordBuilder getMetrics(MetricsSource source) {
        return MetricsAsserts.getMetrics(source, true);
    }

    public static MetricsInfo eqName(MetricsInfo info) {
        return Mockito.argThat(new InfoWithSameName(info));
    }

    public static MetricsInfo anyInfo() {
        return Mockito.argThat(new AnyInfo());
    }

    public static void assertGauge(String name, int expected, MetricsRecordBuilder rb) {
        Assert.assertEquals((String)("Bad value for metric " + name), (long)expected, (long)MetricsAsserts.getIntGauge(name, rb));
    }

    public static int getIntGauge(String name, MetricsRecordBuilder rb) {
        ArgumentCaptor<Integer> captor = ArgumentCaptor.forClass(Integer.class);
        Mockito.verify(rb, Mockito.atLeast(0)).addGauge(MetricsAsserts.eqName(Interns.info((String)name, (String)"")), captor.capture().intValue());
        MetricsAsserts.checkCaptured(captor, name);
        return captor.getValue();
    }

    public static void assertCounter(String name, int expected, MetricsRecordBuilder rb) {
        Assert.assertEquals((String)("Bad value for metric " + name), (long)expected, (long)MetricsAsserts.getIntCounter(name, rb));
    }

    public static int getIntCounter(String name, MetricsRecordBuilder rb) {
        ArgumentCaptor<Integer> captor = ArgumentCaptor.forClass(Integer.class);
        Mockito.verify(rb, Mockito.atLeast(0)).addCounter(MetricsAsserts.eqName(Interns.info((String)name, (String)"")), captor.capture().intValue());
        MetricsAsserts.checkCaptured(captor, name);
        return captor.getValue();
    }

    public static void assertGauge(String name, long expected, MetricsRecordBuilder rb) {
        Assert.assertEquals((String)("Bad value for metric " + name), (long)expected, (long)MetricsAsserts.getLongGauge(name, rb));
    }

    public static long getLongGauge(String name, MetricsRecordBuilder rb) {
        ArgumentCaptor<Long> captor = ArgumentCaptor.forClass(Long.class);
        Mockito.verify(rb, Mockito.atLeast(0)).addGauge(MetricsAsserts.eqName(Interns.info((String)name, (String)"")), captor.capture().longValue());
        MetricsAsserts.checkCaptured(captor, name);
        return captor.getValue();
    }

    public static void assertGauge(String name, double expected, MetricsRecordBuilder rb) {
        Assert.assertEquals((String)("Bad value for metric " + name), (double)expected, (double)MetricsAsserts.getDoubleGauge(name, rb), (double)1.0E-5);
    }

    public static double getDoubleGauge(String name, MetricsRecordBuilder rb) {
        ArgumentCaptor<Double> captor = ArgumentCaptor.forClass(Double.class);
        Mockito.verify(rb, Mockito.atLeast(0)).addGauge(MetricsAsserts.eqName(Interns.info((String)name, (String)"")), captor.capture().doubleValue());
        MetricsAsserts.checkCaptured(captor, name);
        return captor.getValue();
    }

    public static void assertCounter(String name, long expected, MetricsRecordBuilder rb) {
        Assert.assertEquals((String)("Bad value for metric " + name), (long)expected, (long)MetricsAsserts.getLongCounter(name, rb));
    }

    public static long getLongCounter(String name, MetricsRecordBuilder rb) {
        ArgumentCaptor<Long> captor = ArgumentCaptor.forClass(Long.class);
        Mockito.verify(rb, Mockito.atLeast(0)).addCounter(MetricsAsserts.eqName(Interns.info((String)name, (String)"")), captor.capture().longValue());
        MetricsAsserts.checkCaptured(captor, name);
        return captor.getValue();
    }

    public static long getLongCounterWithoutCheck(String name, MetricsRecordBuilder rb) {
        ArgumentCaptor<Long> captor = ArgumentCaptor.forClass(Long.class);
        Mockito.verify(rb, Mockito.atLeast(0)).addCounter(MetricsAsserts.eqName(Interns.info((String)name, (String)"")), captor.capture().longValue());
        return captor.getValue();
    }

    public static String getStringMetric(String name, MetricsRecordBuilder rb) {
        ArgumentCaptor<String> captor = ArgumentCaptor.forClass(String.class);
        Mockito.verify(rb, Mockito.atLeast(0)).tag(MetricsAsserts.eqName(Interns.info((String)name, (String)"")), captor.capture());
        MetricsAsserts.checkCaptured(captor, name);
        return captor.getValue();
    }

    public static void assertGauge(String name, float expected, MetricsRecordBuilder rb) {
        Assert.assertEquals((String)("Bad value for metric " + name), (double)expected, (double)MetricsAsserts.getFloatGauge(name, rb), (double)1.0E-5);
    }

    public static float getFloatGauge(String name, MetricsRecordBuilder rb) {
        ArgumentCaptor<Float> captor = ArgumentCaptor.forClass(Float.class);
        Mockito.verify(rb, Mockito.atLeast(0)).addGauge(MetricsAsserts.eqName(Interns.info((String)name, (String)"")), captor.capture().floatValue());
        MetricsAsserts.checkCaptured(captor, name);
        return captor.getValue().floatValue();
    }

    private static void checkCaptured(ArgumentCaptor<?> captor, String name) {
        Assert.assertEquals((String)("Expected exactly one metric for name " + name), (long)1L, (long)captor.getAllValues().size());
    }

    public static void assertGauge(String name, int expected, MetricsSource source) {
        MetricsAsserts.assertGauge(name, expected, MetricsAsserts.getMetrics(source));
    }

    public static void assertCounter(String name, int expected, MetricsSource source) {
        MetricsAsserts.assertCounter(name, expected, MetricsAsserts.getMetrics(source));
    }

    public static void assertGauge(String name, long expected, MetricsSource source) {
        MetricsAsserts.assertGauge(name, expected, MetricsAsserts.getMetrics(source));
    }

    public static void assertCounter(String name, long expected, MetricsSource source) {
        MetricsAsserts.assertCounter(name, expected, MetricsAsserts.getMetrics(source));
    }

    public static void assertCounterGt(String name, long greater, MetricsRecordBuilder rb) {
        Assert.assertTrue((String)("Bad value for metric " + name), (MetricsAsserts.getLongCounter(name, rb) > greater ? 1 : 0) != 0);
    }

    public static void assertCounterGt(String name, long greater, MetricsSource source) {
        MetricsAsserts.assertCounterGt(name, greater, MetricsAsserts.getMetrics(source));
    }

    public static void assertGaugeGt(String name, double greater, MetricsRecordBuilder rb) {
        Assert.assertTrue((String)("Bad value for metric " + name), (MetricsAsserts.getDoubleGauge(name, rb) > greater ? 1 : 0) != 0);
    }

    public static void assertGaugeGt(String name, double greater, MetricsSource source) {
        MetricsAsserts.assertGaugeGt(name, greater, MetricsAsserts.getMetrics(source));
    }

    public static void assertQuantileGauges(String prefix, MetricsRecordBuilder rb) {
        MetricsAsserts.assertQuantileGauges(prefix, rb, "Latency");
    }

    public static void assertQuantileGauges(String prefix, MetricsRecordBuilder rb, String valueName) {
        Mockito.verify(rb).addGauge(MetricsAsserts.eqName(Interns.info((String)(prefix + "NumOps"), (String)"")), AdditionalMatchers.geq(0L));
        for (Quantile q : MutableQuantiles.quantiles) {
            String nameTemplate = prefix + "%dthPercentile" + valueName;
            int percentile = (int)(100.0 * q.quantile);
            Mockito.verify(rb).addGauge(MetricsAsserts.eqName(Interns.info((String)String.format(nameTemplate, percentile), (String)"")), AdditionalMatchers.geq(0L));
        }
    }

    private static class AnyInfo
    extends ArgumentMatcher<MetricsInfo> {
        private AnyInfo() {
        }

        @Override
        public boolean matches(Object info) {
            return info instanceof MetricsInfo;
        }
    }

    private static class InfoWithSameName
    extends ArgumentMatcher<MetricsInfo> {
        private final String expected;

        InfoWithSameName(MetricsInfo info) {
            this.expected = (String)Preconditions.checkNotNull((Object)info.name(), (Object)"info name");
        }

        @Override
        public boolean matches(Object info) {
            return this.expected.equals(((MetricsInfo)info).name());
        }

        @Override
        public void describeTo(Description desc) {
            desc.appendText("Info with name=" + this.expected);
        }
    }
}

