/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum;

import io.hops.hadoop.shaded.org.apache.commons.io.FileUtils;
import io.hops.hadoop.shaded.org.apache.zookeeper.PortAssignment;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.ClientX509Util;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.KeyStoreFileType;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.X509KeyType;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.X509TestContext;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.X509Util;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.UnifiedServerSocket;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import io.hops.hadoop.shaded.org.bouncycastle.jce.provider.BouncyCastleProvider;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class UnifiedServerSocketModeDetectionTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(UnifiedServerSocketModeDetectionTest.class);
    private static File tempDir;
    private static X509TestContext x509TestContext;
    private boolean useSecureClient;
    private X509Util x509Util;
    private UnifiedServerSocket listeningSocket;
    private UnifiedServerSocket.UnifiedSocket serverSideSocket;
    private Socket clientSocket;
    private ExecutorService workerPool;
    private int port;
    private InetSocketAddress localServerAddress;

    @Parameterized.Parameters
    public static Collection<Object[]> params() {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        result.add(new Object[]{true});
        result.add(new Object[]{false});
        return result;
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        tempDir = ClientBase.createEmptyTestDir();
        x509TestContext = X509TestContext.newBuilder().setTempDir(tempDir).setKeyStoreKeyType(X509KeyType.EC).setTrustStoreKeyType(X509KeyType.EC).build();
    }

    @AfterClass
    public static void tearDownClass() {
        try {
            FileUtils.deleteDirectory((File)tempDir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Security.removeProvider("BC");
    }

    private static void forceClose(Socket s) {
        if (s == null || s.isClosed()) {
            return;
        }
        try {
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void forceClose(ServerSocket s) {
        if (s == null || s.isClosed()) {
            return;
        }
        try {
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public UnifiedServerSocketModeDetectionTest(Boolean useSecureClient) {
        this.useSecureClient = useSecureClient;
    }

    @Before
    public void setUp() throws Exception {
        this.x509Util = new ClientX509Util();
        x509TestContext.setSystemProperties(this.x509Util, KeyStoreFileType.JKS, KeyStoreFileType.JKS);
        System.setProperty(this.x509Util.getSslHandshakeDetectionTimeoutMillisProperty(), "100");
        this.workerPool = Executors.newCachedThreadPool();
        this.port = PortAssignment.unique();
        this.localServerAddress = new InetSocketAddress(InetAddress.getLoopbackAddress(), this.port);
        this.listeningSocket = new UnifiedServerSocket(this.x509Util, true);
        this.listeningSocket.bind(this.localServerAddress);
        Future<UnifiedServerSocket.UnifiedSocket> acceptFuture = this.workerPool.submit(new Callable<UnifiedServerSocket.UnifiedSocket>(){

            @Override
            public UnifiedServerSocket.UnifiedSocket call() throws Exception {
                try {
                    return (UnifiedServerSocket.UnifiedSocket)UnifiedServerSocketModeDetectionTest.this.listeningSocket.accept();
                }
                catch (IOException e) {
                    LOG.error("Error in accept()", (Throwable)e);
                    throw e;
                }
            }
        });
        if (this.useSecureClient) {
            this.clientSocket = this.x509Util.createSSLSocket();
            this.clientSocket.connect(this.localServerAddress);
        } else {
            this.clientSocket = new Socket();
            this.clientSocket.connect(this.localServerAddress);
            this.clientSocket.getOutputStream().write(new byte[]{1, 2, 3, 4, 5});
        }
        this.serverSideSocket = acceptFuture.get();
    }

    @After
    public void tearDown() throws Exception {
        x509TestContext.clearSystemProperties(this.x509Util);
        System.clearProperty(this.x509Util.getSslHandshakeDetectionTimeoutMillisProperty());
        UnifiedServerSocketModeDetectionTest.forceClose(this.listeningSocket);
        UnifiedServerSocketModeDetectionTest.forceClose(this.serverSideSocket);
        UnifiedServerSocketModeDetectionTest.forceClose(this.clientSocket);
        this.workerPool.shutdown();
        this.workerPool.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        this.x509Util.close();
    }

    @Test
    public void testGetInetAddress() {
        this.serverSideSocket.getInetAddress();
        Assert.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @Test
    public void testGetLocalAddress() {
        this.serverSideSocket.getLocalAddress();
        Assert.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @Test
    public void testGetPort() {
        this.serverSideSocket.getPort();
        Assert.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @Test
    public void testGetLocalPort() {
        this.serverSideSocket.getLocalPort();
        Assert.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @Test
    public void testGetRemoteSocketAddress() {
        this.serverSideSocket.getRemoteSocketAddress();
        Assert.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @Test
    public void testGetLocalSocketAddress() {
        this.serverSideSocket.getLocalSocketAddress();
        Assert.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @Test
    public void testGetInputStream() throws IOException {
        this.serverSideSocket.getInputStream();
        Assert.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @Test
    public void testGetOutputStream() throws IOException {
        this.serverSideSocket.getOutputStream();
        Assert.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @Test
    public void testGetTcpNoDelay() throws IOException {
        this.serverSideSocket.getTcpNoDelay();
        Assert.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @Test
    public void testSetTcpNoDelay() throws IOException {
        boolean tcpNoDelay = this.serverSideSocket.getTcpNoDelay();
        tcpNoDelay = !tcpNoDelay;
        this.serverSideSocket.setTcpNoDelay(tcpNoDelay);
        Assert.assertFalse((boolean)this.serverSideSocket.isModeKnown());
        Assert.assertEquals((Object)tcpNoDelay, (Object)this.serverSideSocket.getTcpNoDelay());
    }

    @Test
    public void testGetSoLinger() throws IOException {
        this.serverSideSocket.getSoLinger();
        Assert.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @Test
    public void testSetSoLinger() throws IOException {
        int soLinger = this.serverSideSocket.getSoLinger();
        if (soLinger == -1) {
            this.serverSideSocket.setSoLinger(true, 1);
            Assert.assertFalse((boolean)this.serverSideSocket.isModeKnown());
            Assert.assertEquals((long)1L, (long)this.serverSideSocket.getSoLinger());
        } else {
            this.serverSideSocket.setSoLinger(false, -1);
            Assert.assertFalse((boolean)this.serverSideSocket.isModeKnown());
            Assert.assertEquals((long)-1L, (long)this.serverSideSocket.getSoLinger());
        }
    }

    @Test
    public void testGetSoTimeout() throws IOException {
        this.serverSideSocket.getSoTimeout();
        Assert.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @Test
    public void testSetSoTimeout() throws IOException {
        int timeout = this.serverSideSocket.getSoTimeout();
        this.serverSideSocket.setSoTimeout(timeout += 10);
        Assert.assertFalse((boolean)this.serverSideSocket.isModeKnown());
        Assert.assertEquals((long)timeout, (long)this.serverSideSocket.getSoTimeout());
    }

    @Test
    public void testGetSendBufferSize() throws IOException {
        this.serverSideSocket.getSendBufferSize();
        Assert.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @Test
    public void testSetSendBufferSize() throws IOException {
        this.serverSideSocket.setSendBufferSize(this.serverSideSocket.getSendBufferSize() + 1024);
        Assert.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @Test
    public void testGetReceiveBufferSize() throws IOException {
        this.serverSideSocket.getReceiveBufferSize();
        Assert.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @Test
    public void testSetReceiveBufferSize() throws IOException {
        this.serverSideSocket.setReceiveBufferSize(this.serverSideSocket.getReceiveBufferSize() + 1024);
        Assert.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @Test
    public void testGetKeepAlive() throws IOException {
        this.serverSideSocket.getKeepAlive();
        Assert.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @Test
    public void testSetKeepAlive() throws IOException {
        boolean keepAlive = this.serverSideSocket.getKeepAlive();
        keepAlive = !keepAlive;
        this.serverSideSocket.setKeepAlive(keepAlive);
        Assert.assertFalse((boolean)this.serverSideSocket.isModeKnown());
        Assert.assertEquals((Object)keepAlive, (Object)this.serverSideSocket.getKeepAlive());
    }

    @Test
    public void testGetTrafficClass() throws IOException {
        this.serverSideSocket.getTrafficClass();
        Assert.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @Test
    public void testSetTrafficClass() throws IOException {
        this.serverSideSocket.setTrafficClass(3);
        Assert.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @Test
    public void testGetReuseAddress() throws IOException {
        this.serverSideSocket.getReuseAddress();
        Assert.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @Test
    public void testSetReuseAddress() throws IOException {
        boolean reuseAddress = this.serverSideSocket.getReuseAddress();
        reuseAddress = !reuseAddress;
        this.serverSideSocket.setReuseAddress(reuseAddress);
        Assert.assertFalse((boolean)this.serverSideSocket.isModeKnown());
        Assert.assertEquals((Object)reuseAddress, (Object)this.serverSideSocket.getReuseAddress());
    }

    @Test
    public void testClose() throws IOException {
        this.serverSideSocket.close();
        Assert.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @Test
    public void testShutdownInput() throws IOException {
        this.serverSideSocket.shutdownInput();
        Assert.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @Test
    public void testShutdownOutput() throws IOException {
        this.serverSideSocket.shutdownOutput();
        Assert.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @Test
    public void testIsConnected() {
        this.serverSideSocket.isConnected();
        Assert.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @Test
    public void testIsBound() {
        this.serverSideSocket.isBound();
        Assert.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @Test
    public void testIsClosed() {
        this.serverSideSocket.isClosed();
        Assert.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @Test
    public void testIsInputShutdown() throws IOException {
        this.serverSideSocket.isInputShutdown();
        Assert.assertFalse((boolean)this.serverSideSocket.isModeKnown());
        this.serverSideSocket.shutdownInput();
        Assert.assertTrue((boolean)this.serverSideSocket.isInputShutdown());
    }

    @Test
    public void testIsOutputShutdown() throws IOException {
        this.serverSideSocket.isOutputShutdown();
        Assert.assertFalse((boolean)this.serverSideSocket.isModeKnown());
        this.serverSideSocket.shutdownOutput();
        Assert.assertTrue((boolean)this.serverSideSocket.isOutputShutdown());
    }
}

