/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence;

import io.hops.hadoop.shaded.org.apache.jute.BinaryInputArchive;
import io.hops.hadoop.shaded.org.apache.jute.BinaryOutputArchive;
import io.hops.hadoop.shaded.org.apache.jute.InputArchive;
import io.hops.hadoop.shaded.org.apache.jute.OutputArchive;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.DataTree;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.FileHeader;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.SnapShot;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.SnapStream;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.SnapshotInfo;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.Util;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.util.SerializeUtils;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSnap
implements SnapShot {
    File snapDir;
    SnapshotInfo lastSnapshotInfo = null;
    private volatile boolean close = false;
    private static final int VERSION = 2;
    private static final long dbId = -1L;
    private static final Logger LOG = LoggerFactory.getLogger(FileSnap.class);
    public static final int SNAP_MAGIC = ByteBuffer.wrap("ZKSN".getBytes()).getInt();
    public static final String SNAPSHOT_FILE_PREFIX = "snapshot";

    public FileSnap(File snapDir) {
        this.snapDir = snapDir;
    }

    @Override
    public SnapshotInfo getLastSnapshotInfo() {
        return this.lastSnapshotInfo;
    }

    @Override
    public long deserialize(DataTree dt, Map<Long, Integer> sessions) throws IOException {
        List<File> snapList = this.findNValidSnapshots(100);
        if (snapList.size() == 0) {
            return -1L;
        }
        File snap = null;
        long snapZxid = -1L;
        boolean foundValid = false;
        int snapListSize = snapList.size();
        for (int i = 0; i < snapListSize; ++i) {
            snap = snapList.get(i);
            LOG.info("Reading snapshot {}", (Object)snap);
            snapZxid = Util.getZxidFromName(snap.getName(), SNAPSHOT_FILE_PREFIX);
            try (CheckedInputStream snapIS = SnapStream.getInputStream(snap);){
                BinaryInputArchive ia = BinaryInputArchive.getArchive(snapIS);
                this.deserialize(dt, sessions, ia);
                SnapStream.checkSealIntegrity(snapIS, ia);
                if (dt.deserializeZxidDigest(ia, snapZxid)) {
                    SnapStream.checkSealIntegrity(snapIS, ia);
                }
                foundValid = true;
                break;
            }
            catch (IOException e) {
                LOG.warn("problem reading snap file {}", (Object)snap, (Object)e);
                continue;
            }
        }
        if (!foundValid) {
            throw new IOException("Not able to find valid snapshots in " + this.snapDir);
        }
        dt.lastProcessedZxid = snapZxid;
        this.lastSnapshotInfo = new SnapshotInfo(dt.lastProcessedZxid, snap.lastModified() / 1000L);
        if (dt.getDigestFromLoadedSnapshot() != null) {
            dt.compareSnapshotDigests(dt.lastProcessedZxid);
        }
        return dt.lastProcessedZxid;
    }

    public void deserialize(DataTree dt, Map<Long, Integer> sessions, InputArchive ia) throws IOException {
        FileHeader header = new FileHeader();
        header.deserialize(ia, "fileheader");
        if (header.getMagic() != SNAP_MAGIC) {
            throw new IOException("mismatching magic headers " + header.getMagic() + " !=  " + SNAP_MAGIC);
        }
        SerializeUtils.deserializeSnapshot(dt, ia, sessions);
    }

    @Override
    public File findMostRecentSnapshot() throws IOException {
        List<File> files = this.findNValidSnapshots(1);
        if (files.size() == 0) {
            return null;
        }
        return files.get(0);
    }

    protected List<File> findNValidSnapshots(int n) throws IOException {
        List<File> files = Util.sortDataDir(this.snapDir.listFiles(), SNAPSHOT_FILE_PREFIX, false);
        int count = 0;
        ArrayList<File> list = new ArrayList<File>();
        for (File f : files) {
            try {
                if (!SnapStream.isValidSnapshot(f)) continue;
                list.add(f);
                if (++count != n) continue;
                break;
            }
            catch (IOException e) {
                LOG.warn("invalid snapshot {}", (Object)f, (Object)e);
            }
        }
        return list;
    }

    public List<File> findNRecentSnapshots(int n) throws IOException {
        List<File> files = Util.sortDataDir(this.snapDir.listFiles(), SNAPSHOT_FILE_PREFIX, false);
        int count = 0;
        ArrayList<File> list = new ArrayList<File>();
        for (File f : files) {
            if (count == n) break;
            if (Util.getZxidFromName(f.getName(), SNAPSHOT_FILE_PREFIX) == -1L) continue;
            ++count;
            list.add(f);
        }
        return list;
    }

    protected void serialize(DataTree dt, Map<Long, Integer> sessions, OutputArchive oa, FileHeader header) throws IOException {
        if (header == null) {
            throw new IllegalStateException("Snapshot's not open for writing: uninitialized header");
        }
        header.serialize(oa, "fileheader");
        SerializeUtils.serializeSnapshot(dt, oa, sessions);
    }

    @Override
    public synchronized void serialize(DataTree dt, Map<Long, Integer> sessions, File snapShot, boolean fsync) throws IOException {
        if (!this.close) {
            try (CheckedOutputStream snapOS = SnapStream.getOutputStream(snapShot, fsync);){
                BinaryOutputArchive oa = BinaryOutputArchive.getArchive(snapOS);
                FileHeader header = new FileHeader(SNAP_MAGIC, 2, -1L);
                this.serialize(dt, sessions, oa, header);
                SnapStream.sealStream(snapOS, oa);
                if (dt.serializeZxidDigest(oa)) {
                    SnapStream.sealStream(snapOS, oa);
                }
                this.lastSnapshotInfo = new SnapshotInfo(Util.getZxidFromName(snapShot.getName(), SNAPSHOT_FILE_PREFIX), snapShot.lastModified() / 1000L);
            }
        } else {
            throw new IOException("FileSnap has already been closed");
        }
    }

    private void writeChecksum(CheckedOutputStream crcOut, OutputArchive oa) throws IOException {
        long val = crcOut.getChecksum().getValue();
        oa.writeLong(val, "val");
        oa.writeString("/", "path");
    }

    private void checkChecksum(CheckedInputStream crcIn, InputArchive ia) throws IOException {
        long checkSum = crcIn.getChecksum().getValue();
        long val = ia.readLong("val");
        ia.readString("path");
        if (val != checkSum) {
            throw new IOException("CRC corruption");
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.close = true;
    }
}

