/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum;

import io.hops.hadoop.shaded.org.apache.zookeeper.PortAssignment;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.Leader;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPacket;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.StateSummary;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.SyncedLearnerTracker;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.ZabUtils;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LeaderWithObserverTest {
    QuorumPeer peer;
    Leader leader;
    File tmpDir;
    long participantId;
    long observerId;

    @Before
    public void setUp() throws Exception {
        this.tmpDir = ClientBase.createTmpDir();
        this.peer = ZabUtils.createQuorumPeer(this.tmpDir);
        this.participantId = 1L;
        Map<Long, QuorumPeer.QuorumServer> peers = this.peer.getQuorumVerifier().getAllMembers();
        this.observerId = peers.size();
        this.peer.leader = this.leader = ZabUtils.createLeader(this.tmpDir, this.peer);
        peers.put(this.observerId, new QuorumPeer.QuorumServer(this.observerId, new InetSocketAddress("127.0.0.1", PortAssignment.unique()), new InetSocketAddress("127.0.0.1", PortAssignment.unique()), new InetSocketAddress("127.0.0.1", PortAssignment.unique()), QuorumPeer.LearnerType.OBSERVER));
        this.peer.tickTime = 1;
    }

    @After
    public void tearDown() {
        this.leader.shutdown("end of test");
        this.tmpDir.delete();
    }

    @Test
    public void testGetEpochToPropose() throws Exception {
        long lastAcceptedEpoch = 5L;
        this.peer.setAcceptedEpoch(5L);
        Assert.assertEquals((String)"Unexpected vote in connectingFollowers", (long)0L, (long)this.leader.connectingFollowers.size());
        Assert.assertTrue((boolean)this.leader.waitingForNewEpoch);
        try {
            this.leader.getEpochToPropose(this.peer.getId(), lastAcceptedEpoch);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((String)"Unexpected vote in connectingFollowers", (long)1L, (long)this.leader.connectingFollowers.size());
        Assert.assertEquals((String)"Leader shouldn't set new epoch until quorum of participants is in connectingFollowers", (long)lastAcceptedEpoch, (long)this.peer.getAcceptedEpoch());
        Assert.assertTrue((boolean)this.leader.waitingForNewEpoch);
        try {
            this.leader.getEpochToPropose(this.observerId, lastAcceptedEpoch);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((String)"Unexpected vote in connectingFollowers", (long)1L, (long)this.leader.connectingFollowers.size());
        Assert.assertEquals((String)"Leader shouldn't set new epoch after observer asks for epoch", (long)lastAcceptedEpoch, (long)this.peer.getAcceptedEpoch());
        Assert.assertTrue((boolean)this.leader.waitingForNewEpoch);
        try {
            this.leader.getEpochToPropose(this.participantId, lastAcceptedEpoch);
        }
        catch (Exception e) {
            Assert.fail((String)"Timed out in getEpochToPropose");
        }
        Assert.assertEquals((String)"Unexpected vote in connectingFollowers", (long)2L, (long)this.leader.connectingFollowers.size());
        Assert.assertEquals((String)"Leader should record next epoch", (long)(lastAcceptedEpoch + 1L), (long)this.peer.getAcceptedEpoch());
        Assert.assertFalse((boolean)this.leader.waitingForNewEpoch);
    }

    @Test
    public void testWaitForEpochAck() throws Exception {
        this.leader.leaderStateSummary = new StateSummary(this.leader.self.getCurrentEpoch(), this.leader.zk.getLastProcessedZxid());
        Assert.assertEquals((String)"Unexpected vote in electingFollowers", (long)0L, (long)this.leader.electingFollowers.size());
        Assert.assertFalse((boolean)this.leader.electionFinished);
        try {
            this.leader.waitForEpochAck(this.peer.getId(), new StateSummary(0L, 0L));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((String)"Unexpected vote in electingFollowers", (long)1L, (long)this.leader.electingFollowers.size());
        Assert.assertFalse((boolean)this.leader.electionFinished);
        try {
            this.leader.waitForEpochAck(this.observerId, new StateSummary(0L, 0L));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((String)"Unexpected vote in electingFollowers", (long)1L, (long)this.leader.electingFollowers.size());
        Assert.assertFalse((boolean)this.leader.electionFinished);
        try {
            this.leader.waitForEpochAck(this.participantId, new StateSummary(0L, 0L));
            Assert.assertEquals((String)"Unexpected vote in electingFollowers", (long)2L, (long)this.leader.electingFollowers.size());
            Assert.assertTrue((boolean)this.leader.electionFinished);
        }
        catch (Exception e) {
            Assert.fail((String)"Timed out in waitForEpochAck");
        }
    }

    @Test
    public void testWaitForNewLeaderAck() throws Exception {
        long zxid = this.leader.zk.getZxid();
        this.leader.newLeaderProposal.packet = new QuorumPacket(0, zxid, null, null);
        this.leader.newLeaderProposal.addQuorumVerifier(this.peer.getQuorumVerifier());
        HashSet<Long> ackSet = ((SyncedLearnerTracker.QuorumVerifierAcksetPair)this.leader.newLeaderProposal.qvAcksetPairs.get(0)).getAckset();
        Assert.assertEquals((String)"Unexpected vote in ackSet", (long)0L, (long)ackSet.size());
        Assert.assertFalse((boolean)this.leader.quorumFormed);
        try {
            this.leader.waitForNewLeaderAck(this.peer.getId(), zxid);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((String)"Unexpected vote in ackSet", (long)1L, (long)ackSet.size());
        Assert.assertFalse((boolean)this.leader.quorumFormed);
        try {
            this.leader.waitForNewLeaderAck(this.observerId, zxid);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((String)"Unexpected vote in ackSet", (long)1L, (long)ackSet.size());
        Assert.assertFalse((boolean)this.leader.quorumFormed);
        try {
            this.leader.waitForNewLeaderAck(this.participantId, zxid);
            Assert.assertEquals((String)"Unexpected vote in ackSet", (long)2L, (long)ackSet.size());
            Assert.assertTrue((boolean)this.leader.quorumFormed);
        }
        catch (Exception e) {
            Assert.fail((String)"Timed out in waitForEpochAck");
        }
    }
}

