/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.EphemeralType;
import io.hops.hadoop.shaded.org.hamcrest.CoreMatchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EphemeralTypeTest {
    @Before
    public void setUp() {
        System.setProperty("zookeeper.extendedTypesEnabled", "true");
    }

    @After
    public void tearDown() {
        System.clearProperty("zookeeper.extendedTypesEnabled");
    }

    @Test
    public void testTtls() {
        long[] ttls;
        for (long ttl : ttls = new long[]{100L, 1L, EphemeralType.TTL.maxValue()}) {
            long ephemeralOwner = EphemeralType.TTL.toEphemeralOwner(ttl);
            Assert.assertEquals((Object)((Object)EphemeralType.TTL), (Object)((Object)EphemeralType.get(ephemeralOwner)));
            Assert.assertEquals((long)ttl, (long)EphemeralType.TTL.getValue(ephemeralOwner));
        }
        EphemeralType.validateTTL(CreateMode.PERSISTENT_WITH_TTL, 100L);
        EphemeralType.validateTTL(CreateMode.PERSISTENT_SEQUENTIAL_WITH_TTL, 100L);
        try {
            EphemeralType.validateTTL(CreateMode.EPHEMERAL, 100L);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testContainerValue() {
        Assert.assertEquals((long)Long.MIN_VALUE, (long)Long.MIN_VALUE);
        Assert.assertEquals((Object)((Object)EphemeralType.CONTAINER), (Object)((Object)EphemeralType.get(Long.MIN_VALUE)));
    }

    @Test
    public void testNonSpecial() {
        Assert.assertEquals((Object)((Object)EphemeralType.VOID), (Object)((Object)EphemeralType.get(0L)));
        Assert.assertEquals((Object)((Object)EphemeralType.NORMAL), (Object)((Object)EphemeralType.get(1L)));
        Assert.assertEquals((Object)((Object)EphemeralType.NORMAL), (Object)((Object)EphemeralType.get(Long.MAX_VALUE)));
    }

    @Test
    public void testServerIds() {
        int i = 0;
        while ((long)i <= 254L) {
            EphemeralType.validateServerId(i);
            ++i;
        }
        try {
            EphemeralType.validateServerId(255L);
            Assert.fail((String)"Should have thrown RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testEphemeralOwner_extendedFeature_TTL() {
        Assert.assertThat((Object)((Object)EphemeralType.get(-72057594037927936L)), CoreMatchers.equalTo(EphemeralType.TTL));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEphemeralOwner_extendedFeature_extendedTypeUnsupported() {
        EphemeralType.get(-72056494526300160L);
    }
}

