/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.util;

import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.util.ConfigUtils;
import org.junit.Assert;
import org.junit.Test;

public class ConfigUtilsTest {
    @Test
    public void testGetHostAndPortWithIPv6() throws QuorumPeerConfig.ConfigException {
        String[] nsa = ConfigUtils.getHostAndPort("[2001:db8:85a3:8d3:1319:8a2e:370:7348]:443");
        Assert.assertEquals((Object)nsa[0], (Object)"2001:db8:85a3:8d3:1319:8a2e:370:7348");
        Assert.assertEquals((Object)nsa[1], (Object)"443");
        nsa = ConfigUtils.getHostAndPort("[2001:db8:1::242:ac11:2]:2888:3888");
        Assert.assertEquals((Object)nsa[0], (Object)"2001:db8:1::242:ac11:2");
        Assert.assertEquals((Object)nsa[1], (Object)"2888");
        Assert.assertEquals((Object)nsa[2], (Object)"3888");
    }

    @Test
    public void testGetHostAndPortWithIPv4() throws QuorumPeerConfig.ConfigException {
        String[] nsa = ConfigUtils.getHostAndPort("127.0.0.1:443");
        Assert.assertEquals((Object)nsa[0], (Object)"127.0.0.1");
        Assert.assertEquals((Object)nsa[1], (Object)"443");
        nsa = ConfigUtils.getHostAndPort("127.0.0.1:2888:3888");
        Assert.assertEquals((Object)nsa[0], (Object)"127.0.0.1");
        Assert.assertEquals((Object)nsa[1], (Object)"2888");
        Assert.assertEquals((Object)nsa[2], (Object)"3888");
    }

    @Test(expected=QuorumPeerConfig.ConfigException.class)
    public void testGetHostAndPortWithoutBracket() throws QuorumPeerConfig.ConfigException {
        String[] nsa = ConfigUtils.getHostAndPort("[2001:db8:85a3:8d3:1319:8a2e:370:7348");
    }

    @Test(expected=QuorumPeerConfig.ConfigException.class)
    public void testGetHostAndPortWithoutPortAfterColon() throws QuorumPeerConfig.ConfigException {
        String[] nsa = ConfigUtils.getHostAndPort("[2001:db8:1::242:ac11:2]:");
    }

    @Test
    public void testGetHostAndPortWithoutPort() throws QuorumPeerConfig.ConfigException {
        String[] nsa = ConfigUtils.getHostAndPort("127.0.0.1");
        Assert.assertEquals((Object)nsa[0], (Object)"127.0.0.1");
        Assert.assertEquals((long)nsa.length, (long)1L);
        nsa = ConfigUtils.getHostAndPort("[2001:db8:1::242:ac11:2]");
        Assert.assertEquals((Object)nsa[0], (Object)"2001:db8:1::242:ac11:2");
        Assert.assertEquals((long)nsa.length, (long)1L);
    }

    @Test
    public void testGetPropertyBackwardCompatibleWay() throws QuorumPeerConfig.ConfigException {
        String newProp = "zookeeper.prop.x.y.z";
        String oldProp = "prop.x.y.z";
        String result = ConfigUtils.getPropertyBackwardCompatibleWay(newProp);
        Assert.assertNull((Object)result);
        String oldPropValue = "oldPropertyValue";
        System.setProperty(oldProp, oldPropValue);
        result = ConfigUtils.getPropertyBackwardCompatibleWay(newProp);
        Assert.assertEquals((Object)oldPropValue, (Object)result);
        String newPropValue = "newPropertyValue";
        System.setProperty(newProp, newPropValue);
        result = ConfigUtils.getPropertyBackwardCompatibleWay(newProp);
        Assert.assertEquals((Object)newPropValue, (Object)result);
        this.clearProp(newProp, oldProp);
        System.setProperty(oldProp, oldPropValue + "  ");
        result = ConfigUtils.getPropertyBackwardCompatibleWay(newProp);
        Assert.assertEquals((Object)oldPropValue, (Object)result);
        System.setProperty(newProp, "  " + newPropValue);
        result = ConfigUtils.getPropertyBackwardCompatibleWay(newProp);
        Assert.assertEquals((Object)newPropValue, (Object)result);
        this.clearProp(newProp, oldProp);
    }

    private void clearProp(String newProp, String oldProp) {
        System.clearProperty(newProp);
        System.clearProperty(oldProp);
    }
}

