/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import io.hops.hadoop.shaded.org.apache.avro.Schema;
import io.hops.hadoop.shaded.org.apache.avro.io.Decoder;
import io.hops.hadoop.shaded.org.apache.avro.io.DecoderFactory;
import io.hops.hadoop.shaded.org.apache.avro.io.Encoder;
import io.hops.hadoop.shaded.org.apache.avro.io.EncoderFactory;
import io.hops.hadoop.shaded.org.apache.avro.reflect.ReflectData;
import io.hops.hadoop.shaded.org.apache.avro.reflect.ReflectDatumReader;
import io.hops.hadoop.shaded.org.apache.avro.reflect.ReflectDatumWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import org.junit.Assert;

public class AvroTestUtil {
    public static void testReflect(Object value, String schema) throws Exception {
        AvroTestUtil.testReflect(value, value.getClass(), schema);
    }

    public static void testReflect(Object value, Type type, String schema) throws Exception {
        Schema s = ReflectData.get().getSchema(type);
        Assert.assertEquals((Object)new Schema.Parser().parse(schema), (Object)s);
        ReflectDatumWriter writer = new ReflectDatumWriter(s);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        writer.write(value, (Encoder)EncoderFactory.get().directBinaryEncoder((OutputStream)out, null));
        ReflectDatumReader reader = new ReflectDatumReader(s);
        Object after = reader.read(null, (Decoder)DecoderFactory.get().binaryDecoder(out.toByteArray(), null));
        Assert.assertEquals((Object)value, (Object)after);
    }
}

