/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.PortAssignment;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.FastLeaderElection;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FLEPredicateTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(FLEPredicateTest.class);
    HashMap<Long, QuorumPeer.QuorumServer> peers;

    @Test
    public void testPredicate() throws IOException {
        this.peers = new HashMap(3);
        for (int i = 0; i < 3; ++i) {
            this.peers.put(Long.valueOf(i), new QuorumPeer.QuorumServer(i, new InetSocketAddress("127.0.0.1", PortAssignment.unique()), new InetSocketAddress("127.0.0.1", PortAssignment.unique())));
        }
        try {
            File tmpDir = ClientBase.createTmpDir();
            QuorumPeer peer = new QuorumPeer(this.peers, tmpDir, tmpDir, PortAssignment.unique(), 3, 0L, 1000, 2, 2, 2);
            MockFLE mock = new MockFLE(peer);
            mock.start();
            Assert.assertFalse((boolean)mock.predicate(4L, 0L, 0L, 3L, 0L, 2L));
            Assert.assertTrue((boolean)mock.predicate(0L, 0L, 1L, 1L, 0L, 0L));
            Assert.assertTrue((boolean)mock.predicate(0L, 1L, 0L, 1L, 0L, 0L));
            Assert.assertTrue((boolean)mock.predicate(1L, 1L, 0L, 0L, 1L, 0L));
        }
        catch (IOException e) {
            LOG.error("Exception while creating quorum peer", (Throwable)e);
            Assert.fail((String)"Exception while creating quorum peer");
        }
    }

    class MockFLE
    extends FastLeaderElection {
        MockFLE(QuorumPeer peer) {
            super(peer, peer.createCnxnManager());
        }

        boolean predicate(long newId, long newZxid, long newEpoch, long curId, long curZxid, long curEpoch) {
            return this.totalOrderPredicate(newId, newZxid, newEpoch, curId, curZxid, curEpoch);
        }
    }
}

