/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.ehcache.core.internal.store;

import io.hops.hadoop.shaded.org.ehcache.config.ResourceType;
import io.hops.hadoop.shaded.org.ehcache.core.spi.store.Store;
import io.hops.hadoop.shaded.org.ehcache.spi.service.Service;
import io.hops.hadoop.shaded.org.ehcache.spi.service.ServiceConfiguration;
import io.hops.hadoop.shaded.org.ehcache.spi.service.ServiceProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

public final class StoreSupport {
    private StoreSupport() {
    }

    public static Store.Provider selectStoreProvider(ServiceProvider<Service> serviceProvider, Set<ResourceType<?>> resourceTypes, Collection<ServiceConfiguration<?>> serviceConfigs) {
        StringBuilder sb;
        Collection<Store.Provider> storeProviders = serviceProvider.getServicesOfType(Store.Provider.class);
        int highRank = 0;
        ArrayList<Store.Provider> rankingProviders = new ArrayList<Store.Provider>();
        for (Store.Provider provider : storeProviders) {
            int rank = provider.rank(resourceTypes, serviceConfigs);
            if (rank > highRank) {
                highRank = rank;
                rankingProviders.clear();
                rankingProviders.add(provider);
                continue;
            }
            if (rank == 0 || rank != highRank) continue;
            rankingProviders.add(provider);
        }
        if (rankingProviders.isEmpty()) {
            sb = new StringBuilder("No Store.Provider found to handle configured resource types ");
            sb.append(resourceTypes);
            sb.append(" from ");
            StoreSupport.formatStoreProviders(storeProviders, sb);
            throw new IllegalStateException(sb.toString());
        }
        if (rankingProviders.size() > 1) {
            sb = new StringBuilder("Multiple Store.Providers found to handle configured resource types ");
            sb.append(resourceTypes);
            sb.append(": ");
            StoreSupport.formatStoreProviders(rankingProviders, sb);
            throw new IllegalStateException(sb.toString());
        }
        return (Store.Provider)rankingProviders.get(0);
    }

    private static StringBuilder formatStoreProviders(Collection<Store.Provider> storeProviders, StringBuilder sb) {
        sb.append('{');
        boolean prependSeparator = false;
        for (Store.Provider provider : storeProviders) {
            if (prependSeparator) {
                sb.append(", ");
            } else {
                prependSeparator = true;
            }
            sb.append(provider.getClass().getName());
        }
        sb.append('}');
        return sb;
    }
}

