/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.watch;

import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.watch.WatchesReport;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WatchesReportTest
extends ZKTestCase {
    private Map<Long, Set<String>> m;
    private WatchesReport r;

    @Before
    public void setUp() {
        this.m = new HashMap<Long, Set<String>>();
        HashSet<String> s = new HashSet<String>();
        s.add("path1a");
        s.add("path1b");
        this.m.put(1L, s);
        s = new HashSet();
        s.add("path2a");
        this.m.put(2L, s);
        this.r = new WatchesReport(this.m);
    }

    @Test
    public void testHasPaths() {
        Assert.assertTrue((boolean)this.r.hasPaths(1L));
        Assert.assertTrue((boolean)this.r.hasPaths(2L));
        Assert.assertFalse((boolean)this.r.hasPaths(3L));
    }

    @Test
    public void testGetPaths() {
        Set<String> s = this.r.getPaths(1L);
        Assert.assertEquals((long)2L, (long)s.size());
        Assert.assertTrue((boolean)s.contains("path1a"));
        Assert.assertTrue((boolean)s.contains("path1b"));
        s = this.r.getPaths(2L);
        Assert.assertEquals((long)1L, (long)s.size());
        Assert.assertTrue((boolean)s.contains("path2a"));
        Assert.assertNull(this.r.getPaths(3L));
    }

    @Test
    public void testToMap() {
        Assert.assertEquals(this.m, this.r.toMap());
    }
}

