/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.mockito.runners;

import io.hops.hadoop.shaded.org.mockito.internal.debugging.WarningsCollector;
import io.hops.hadoop.shaded.org.mockito.internal.runners.RunnerFactory;
import io.hops.hadoop.shaded.org.mockito.internal.runners.RunnerImpl;
import io.hops.hadoop.shaded.org.mockito.internal.util.junit.JUnitFailureHacker;
import java.lang.reflect.InvocationTargetException;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerboseMockitoJUnitRunner
extends Runner
implements Filterable {
    private RunnerImpl runner;

    public VerboseMockitoJUnitRunner(Class<?> klass) throws InvocationTargetException {
        this(new RunnerFactory().create(klass));
    }

    VerboseMockitoJUnitRunner(RunnerImpl runnerImpl) {
        this.runner = runnerImpl;
    }

    public void run(RunNotifier notifier) {
        RunListener listener = new RunListener(){
            WarningsCollector warningsCollector;

            public void testStarted(Description description) throws Exception {
                this.warningsCollector = new WarningsCollector();
            }

            public void testFailure(Failure failure) throws Exception {
                String warnings = this.warningsCollector.getWarnings();
                new JUnitFailureHacker().appendWarnings(failure, warnings);
            }
        };
        notifier.addFirstListener(listener);
        this.runner.run(notifier);
    }

    public Description getDescription() {
        return this.runner.getDescription();
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        this.runner.filter(filter);
    }
}

