/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum;

import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.TxnLogProposalIterator;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZKDatabase;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.Leader;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.LearnerHandler;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPacket;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.util.ZxidUtils;
import io.hops.hadoop.shaded.org.mockito.ArgumentMatchers;
import io.hops.hadoop.shaded.org.mockito.Mockito;
import io.hops.hadoop.shaded.org.mockito.invocation.InvocationOnMock;
import io.hops.hadoop.shaded.org.mockito.stubbing.Answer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LearnerHandlerTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(LearnerHandlerTest.class);
    private MockLearnerHandler learnerHandler;
    private Socket sock;
    private Leader leader;
    private long currentZxid;
    private MockZKDatabase db;

    @Before
    public void setUp() throws Exception {
        this.db = new MockZKDatabase(null);
        this.sock = Mockito.mock(Socket.class);
        this.leader = Mockito.mock(Leader.class);
        Mockito.when(this.leader.startForwarding((LearnerHandler)ArgumentMatchers.any(LearnerHandler.class), ArgumentMatchers.anyLong())).thenAnswer(new Answer<Long>(){

            @Override
            public Long answer(InvocationOnMock invocation) {
                LearnerHandlerTest.this.currentZxid = (Long)invocation.getArgument(1);
                return 0L;
            }
        });
        Mockito.when(this.leader.getZKDatabase()).thenReturn(this.db);
        this.learnerHandler = new MockLearnerHandler(this.sock, this.leader);
    }

    Leader.Proposal createProposal(long zxid) {
        Leader.Proposal p = new Leader.Proposal();
        p.packet = new QuorumPacket();
        p.packet.setZxid(zxid);
        p.packet.setType(2);
        return p;
    }

    public void queuedPacketMatches(long[] zxids) {
        int index = 0;
        for (QuorumPacket qp : this.learnerHandler.getQueuedPackets()) {
            if (qp.getType() != 2) continue;
            this.assertZxidEquals(zxids[index++], qp.getZxid());
        }
    }

    void reset() {
        this.learnerHandler.getQueuedPackets().clear();
        this.learnerHandler.threadStarted = false;
        this.learnerHandler.setFirstPacket(true);
    }

    public void assertOpType(int type, long zxid, long currentZxid) {
        Queue<QuorumPacket> packets = this.learnerHandler.getQueuedPackets();
        Assert.assertTrue((packets.size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)type, (long)packets.peek().getType());
        this.assertZxidEquals(zxid, packets.peek().getZxid());
        this.assertZxidEquals(currentZxid, this.currentZxid);
    }

    void assertZxidEquals(long expected, long value) {
        Assert.assertEquals((String)("Expected 0x" + Long.toHexString(expected) + " but was 0x" + Long.toHexString(value)), (long)expected, (long)value);
    }

    @Test
    public void testEmptyCommittedLog() throws Exception {
        long peerZxid = 3L;
        this.db.lastProcessedZxid = 1L;
        this.db.committedLog.clear();
        Assert.assertFalse((boolean)this.learnerHandler.syncFollower(peerZxid, this.leader));
        this.assertOpType(14, this.db.lastProcessedZxid, this.db.lastProcessedZxid);
        this.reset();
        peerZxid = 1L;
        this.db.lastProcessedZxid = 1L;
        this.db.committedLog.clear();
        Assert.assertFalse((boolean)this.learnerHandler.syncFollower(peerZxid, this.leader));
        this.assertOpType(13, this.db.lastProcessedZxid, this.db.lastProcessedZxid);
        Assert.assertEquals((long)1L, (long)this.learnerHandler.getQueuedPackets().size());
        this.reset();
        peerZxid = 0L;
        this.db.setSnapshotSizeFactor(-1.0);
        this.db.lastProcessedZxid = 1L;
        this.db.committedLog.clear();
        Assert.assertTrue((boolean)this.learnerHandler.syncFollower(peerZxid, this.leader));
        Assert.assertEquals((long)0L, (long)this.learnerHandler.getQueuedPackets().size());
        this.reset();
    }

    @Test
    public void testCommittedLog() throws Exception {
        this.db.lastProcessedZxid = 6L;
        this.db.committedLog.add(this.createProposal(2L));
        this.db.committedLog.add(this.createProposal(3L));
        this.db.committedLog.add(this.createProposal(5L));
        long peerZxid = 4L;
        Assert.assertFalse((boolean)this.learnerHandler.syncFollower(peerZxid, this.leader));
        this.assertOpType(14, 3L, 5L);
        Assert.assertEquals((long)3L, (long)this.learnerHandler.getQueuedPackets().size());
        this.queuedPacketMatches(new long[]{5L});
        this.reset();
        peerZxid = 2L;
        Assert.assertFalse((boolean)this.learnerHandler.syncFollower(peerZxid, this.leader));
        this.assertOpType(13, this.db.getmaxCommittedLog(), this.db.getmaxCommittedLog());
        Assert.assertEquals((long)5L, (long)this.learnerHandler.getQueuedPackets().size());
        this.queuedPacketMatches(new long[]{3L, 5L});
        this.reset();
        peerZxid = 1L;
        this.db.setSnapshotSizeFactor(-1.0);
        Assert.assertTrue((boolean)this.learnerHandler.syncFollower(peerZxid, this.leader));
        Assert.assertEquals((long)0L, (long)this.learnerHandler.getQueuedPackets().size());
        this.reset();
    }

    @Test
    public void testTxnLog() throws Exception {
        this.db.txnLog.add(this.createProposal(2L));
        this.db.txnLog.add(this.createProposal(3L));
        this.db.txnLog.add(this.createProposal(5L));
        this.db.txnLog.add(this.createProposal(6L));
        this.db.txnLog.add(this.createProposal(7L));
        this.db.txnLog.add(this.createProposal(8L));
        this.db.txnLog.add(this.createProposal(9L));
        this.db.lastProcessedZxid = 9L;
        this.db.committedLog.add(this.createProposal(6L));
        this.db.committedLog.add(this.createProposal(7L));
        this.db.committedLog.add(this.createProposal(8L));
        long peerZxid = 4L;
        Assert.assertFalse((boolean)this.learnerHandler.syncFollower(peerZxid, this.leader));
        this.assertOpType(14, 3L, this.db.getmaxCommittedLog());
        Assert.assertEquals((long)9L, (long)this.learnerHandler.getQueuedPackets().size());
        this.queuedPacketMatches(new long[]{5L, 6L, 7L, 8L});
        this.reset();
        peerZxid = 3L;
        Assert.assertFalse((boolean)this.learnerHandler.syncFollower(peerZxid, this.leader));
        this.assertOpType(13, this.db.getmaxCommittedLog(), this.db.getmaxCommittedLog());
        Assert.assertEquals((long)9L, (long)this.learnerHandler.getQueuedPackets().size());
        this.queuedPacketMatches(new long[]{5L, 6L, 7L, 8L});
        this.reset();
    }

    @Test
    public void testTxnLogProposalIteratorClosure() throws Exception {
        this.db = new MockZKDatabase(null){

            @Override
            public Iterator<Leader.Proposal> getProposalsFromTxnLog(long peerZxid, long limit) {
                return TxnLogProposalIterator.EMPTY_ITERATOR;
            }
        };
        this.db.lastProcessedZxid = 7L;
        this.db.txnLog.add(this.createProposal(2L));
        this.db.txnLog.add(this.createProposal(3L));
        Mockito.when(this.leader.getZKDatabase()).thenReturn(this.db);
        long peerZxid = 4L;
        Assert.assertTrue((String)"Couldn't identify snapshot transfer!", (boolean)this.learnerHandler.syncFollower(peerZxid, this.leader));
        this.reset();
    }

    @Test
    public void testTxnLogOnly() throws Exception {
        this.db.lastProcessedZxid = 7L;
        this.db.txnLog.add(this.createProposal(2L));
        this.db.txnLog.add(this.createProposal(3L));
        this.db.txnLog.add(this.createProposal(5L));
        this.db.txnLog.add(this.createProposal(6L));
        this.db.txnLog.add(this.createProposal(7L));
        this.db.txnLog.add(this.createProposal(8L));
        long peerZxid = 4L;
        Assert.assertFalse((boolean)this.learnerHandler.syncFollower(peerZxid, this.leader));
        this.assertOpType(14, 3L, this.db.lastProcessedZxid);
        Assert.assertEquals((long)7L, (long)this.learnerHandler.getQueuedPackets().size());
        this.queuedPacketMatches(new long[]{5L, 6L, 7L});
        this.reset();
        peerZxid = 2L;
        Assert.assertFalse((boolean)this.learnerHandler.syncFollower(peerZxid, this.leader));
        this.assertOpType(13, this.db.lastProcessedZxid, this.db.lastProcessedZxid);
        Assert.assertEquals((long)9L, (long)this.learnerHandler.getQueuedPackets().size());
        this.queuedPacketMatches(new long[]{3L, 5L, 6L, 7L});
        this.reset();
        peerZxid = 1L;
        Assert.assertTrue((boolean)this.learnerHandler.syncFollower(peerZxid, this.leader));
        Assert.assertEquals((long)0L, (long)this.learnerHandler.getQueuedPackets().size());
        this.reset();
    }

    long getZxid(long epoch, long counter) {
        return ZxidUtils.makeZxid(epoch, counter);
    }

    @Test
    public void testTxnLogWithNegativeZxid() throws Exception {
        this.db.txnLog.add(this.createProposal(this.getZxid(15L, 2L)));
        this.db.txnLog.add(this.createProposal(this.getZxid(15L, 3L)));
        this.db.txnLog.add(this.createProposal(this.getZxid(15L, 5L)));
        this.db.txnLog.add(this.createProposal(this.getZxid(15L, 6L)));
        this.db.txnLog.add(this.createProposal(this.getZxid(15L, 7L)));
        this.db.txnLog.add(this.createProposal(this.getZxid(15L, 8L)));
        this.db.txnLog.add(this.createProposal(this.getZxid(15L, 9L)));
        this.db.lastProcessedZxid = this.getZxid(15L, 9L);
        this.db.committedLog.add(this.createProposal(this.getZxid(15L, 6L)));
        this.db.committedLog.add(this.createProposal(this.getZxid(15L, 7L)));
        this.db.committedLog.add(this.createProposal(this.getZxid(15L, 8L)));
        long peerZxid = this.getZxid(15L, 4L);
        Assert.assertFalse((boolean)this.learnerHandler.syncFollower(peerZxid, this.leader));
        this.assertOpType(14, this.getZxid(15L, 3L), this.db.getmaxCommittedLog());
        Assert.assertEquals((long)9L, (long)this.learnerHandler.getQueuedPackets().size());
        this.queuedPacketMatches(new long[]{this.getZxid(15L, 5L), this.getZxid(15L, 6L), this.getZxid(15L, 7L), this.getZxid(15L, 8L)});
        this.reset();
        peerZxid = this.getZxid(15L, 3L);
        Assert.assertFalse((boolean)this.learnerHandler.syncFollower(peerZxid, this.leader));
        this.assertOpType(13, this.db.getmaxCommittedLog(), this.db.getmaxCommittedLog());
        Assert.assertEquals((long)9L, (long)this.learnerHandler.getQueuedPackets().size());
        this.queuedPacketMatches(new long[]{this.getZxid(15L, 5L), this.getZxid(15L, 6L), this.getZxid(15L, 7L), this.getZxid(15L, 8L)});
        this.reset();
    }

    @Test
    public void testNewEpochZxid() throws Exception {
        this.db.txnLog.add(this.createProposal(this.getZxid(0L, 1L)));
        this.db.txnLog.add(this.createProposal(this.getZxid(1L, 1L)));
        this.db.txnLog.add(this.createProposal(this.getZxid(1L, 2L)));
        this.db.lastProcessedZxid = this.getZxid(2L, 0L);
        this.db.committedLog.add(this.createProposal(this.getZxid(1L, 1L)));
        this.db.committedLog.add(this.createProposal(this.getZxid(1L, 2L)));
        long peerZxid = this.getZxid(0L, 0L);
        Assert.assertTrue((boolean)this.learnerHandler.syncFollower(peerZxid, this.leader));
        Assert.assertEquals((long)0L, (long)this.learnerHandler.getQueuedPackets().size());
        this.reset();
        peerZxid = this.getZxid(1L, 0L);
        Assert.assertFalse((boolean)this.learnerHandler.syncFollower(peerZxid, this.leader));
        this.assertOpType(13, this.getZxid(1L, 2L), this.getZxid(1L, 2L));
        Assert.assertEquals((long)5L, (long)this.learnerHandler.getQueuedPackets().size());
        this.queuedPacketMatches(new long[]{this.getZxid(1L, 1L), this.getZxid(1L, 2L)});
        this.reset();
        peerZxid = this.getZxid(2L, 0L);
        Assert.assertFalse((boolean)this.learnerHandler.syncFollower(peerZxid, this.leader));
        this.assertOpType(13, this.getZxid(2L, 0L), this.getZxid(2L, 0L));
        Assert.assertEquals((long)1L, (long)this.learnerHandler.getQueuedPackets().size());
        this.reset();
    }

    @Test
    public void testDuplicatedTxn() throws Exception {
        this.db.txnLog.add(this.createProposal(this.getZxid(0L, 1L)));
        this.db.txnLog.add(this.createProposal(this.getZxid(1L, 1L)));
        this.db.txnLog.add(this.createProposal(this.getZxid(1L, 2L)));
        this.db.txnLog.add(this.createProposal(this.getZxid(1L, 1L)));
        this.db.txnLog.add(this.createProposal(this.getZxid(1L, 2L)));
        this.db.lastProcessedZxid = this.getZxid(2L, 0L);
        this.db.committedLog.add(this.createProposal(this.getZxid(1L, 1L)));
        this.db.committedLog.add(this.createProposal(this.getZxid(1L, 2L)));
        this.db.committedLog.add(this.createProposal(this.getZxid(1L, 1L)));
        this.db.committedLog.add(this.createProposal(this.getZxid(1L, 2L)));
        long peerZxid = this.getZxid(1L, 0L);
        Assert.assertFalse((boolean)this.learnerHandler.syncFollower(peerZxid, this.leader));
        this.assertOpType(13, this.getZxid(1L, 2L), this.getZxid(1L, 2L));
        Assert.assertEquals((long)5L, (long)this.learnerHandler.getQueuedPackets().size());
        this.queuedPacketMatches(new long[]{this.getZxid(1L, 1L), this.getZxid(1L, 2L)});
        this.reset();
    }

    @Test
    public void testCrossEpochTrunc() throws Exception {
        this.db.txnLog.add(this.createProposal(this.getZxid(1L, 1L)));
        this.db.txnLog.add(this.createProposal(this.getZxid(2L, 1L)));
        this.db.txnLog.add(this.createProposal(this.getZxid(2L, 2L)));
        this.db.txnLog.add(this.createProposal(this.getZxid(4L, 1L)));
        this.db.lastProcessedZxid = this.getZxid(6L, 0L);
        long peerZxid = this.getZxid(3L, 1L);
        Assert.assertTrue((boolean)this.learnerHandler.syncFollower(peerZxid, this.leader));
        Assert.assertEquals((long)0L, (long)this.learnerHandler.getQueuedPackets().size());
        this.reset();
    }

    @Test
    public void testTxnLogGap() throws Exception {
        this.db.txnLog.add(this.createProposal(2L));
        this.db.txnLog.add(this.createProposal(3L));
        this.db.txnLog.add(this.createProposal(4L));
        this.db.lastProcessedZxid = 8L;
        this.db.committedLog.add(this.createProposal(7L));
        this.db.committedLog.add(this.createProposal(8L));
        long peerZxid = 3L;
        Assert.assertTrue((boolean)this.learnerHandler.syncFollower(peerZxid, this.leader));
        this.reset();
    }

    class MockZKDatabase
    extends ZKDatabase {
        long lastProcessedZxid;
        ReentrantReadWriteLock lock;
        LinkedList<Leader.Proposal> committedLog;
        LinkedList<Leader.Proposal> txnLog;

        public MockZKDatabase(FileTxnSnapLog snapLog) {
            super(snapLog);
            this.lock = new ReentrantReadWriteLock();
            this.committedLog = new LinkedList();
            this.txnLog = new LinkedList();
        }

        @Override
        public long getDataTreeLastProcessedZxid() {
            return this.lastProcessedZxid;
        }

        @Override
        public long getmaxCommittedLog() {
            if (!this.committedLog.isEmpty()) {
                return this.committedLog.getLast().packet.getZxid();
            }
            return 0L;
        }

        @Override
        public long getminCommittedLog() {
            if (!this.committedLog.isEmpty()) {
                return this.committedLog.getFirst().packet.getZxid();
            }
            return 0L;
        }

        public List<Leader.Proposal> getCommittedLog() {
            return this.committedLog;
        }

        @Override
        public ReentrantReadWriteLock getLogLock() {
            return this.lock;
        }

        @Override
        public Iterator<Leader.Proposal> getProposalsFromTxnLog(long peerZxid, long limit) {
            if (peerZxid >= this.txnLog.peekFirst().packet.getZxid()) {
                return this.txnLog.iterator();
            }
            return Collections.emptyIterator();
        }

        @Override
        public long calculateTxnLogSizeLimit() {
            return 1L;
        }
    }

    class MockLearnerHandler
    extends LearnerHandler {
        boolean threadStarted;

        MockLearnerHandler(Socket sock, Leader leader) throws IOException {
            super(sock, new BufferedInputStream(sock.getInputStream()), leader);
            this.threadStarted = false;
        }

        @Override
        protected void startSendingPackets() {
            this.threadStarted = true;
        }

        @Override
        protected boolean shouldSendMarkerPacketForLogging() {
            return false;
        }
    }
}

