/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server;

import io.hops.hadoop.shaded.org.apache.zookeeper.server.Request;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerCnxnFactory;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperServerBean;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.txn.SetDataTxn;
import io.hops.hadoop.shaded.org.apache.zookeeper.txn.TxnHeader;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ZooKeeperServerBeanTest {
    @Before
    public void setup() {
        System.setProperty("zookeeper.serverCnxnFactory", "io.hops.hadoop.shaded.org.apache.zookeeper.server.NettyServerCnxnFactory");
    }

    @After
    public void teardown() throws Exception {
        System.clearProperty("zookeeper.serverCnxnFactory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTxnLogElapsedSyncTime() throws IOException {
        File tmpDir = ClientBase.createEmptyTestDir();
        FileTxnSnapLog fileTxnSnapLog = new FileTxnSnapLog(new File(tmpDir, "data"), new File(tmpDir, "data_txnlog"));
        ZooKeeperServer zks = new ZooKeeperServer();
        zks.setTxnLogFactory(fileTxnSnapLog);
        ZooKeeperServerBean serverBean = new ZooKeeperServerBean(zks);
        long elapsedTime = serverBean.getTxnLogElapsedSyncTime();
        Assert.assertEquals((long)-1L, (long)elapsedTime);
        TxnHeader hdr = new TxnHeader(1L, 1, 1L, 1L, 5);
        SetDataTxn txn = new SetDataTxn("/foo", new byte[0], 1);
        Request req = new Request(0L, 0, 0, hdr, txn, 0L);
        try {
            zks.getTxnLogFactory().append(req);
            zks.getTxnLogFactory().commit();
            elapsedTime = serverBean.getTxnLogElapsedSyncTime();
            Assert.assertNotEquals((long)-1L, (long)elapsedTime);
            Assert.assertEquals((long)elapsedTime, (long)serverBean.getTxnLogElapsedSyncTime());
        }
        finally {
            fileTxnSnapLog.close();
        }
    }

    @Test
    public void testGetSecureClientPort() throws IOException {
        ZooKeeperServer zks = new ZooKeeperServer();
        ZooKeeperServerBean serverBean = new ZooKeeperServerBean(zks);
        String result = serverBean.getSecureClientPort();
        Assert.assertEquals((Object)"", (Object)result);
        ServerCnxnFactory cnxnFactory = ServerCnxnFactory.createFactory();
        int secureClientPort = 8443;
        InetSocketAddress address = new InetSocketAddress(secureClientPort);
        cnxnFactory.configure(address, 5, -1, true);
        zks.setSecureServerCnxnFactory(cnxnFactory);
        result = serverBean.getSecureClientPort();
        Assert.assertEquals((Object)Integer.toString(secureClientPort), (Object)result);
        cnxnFactory.shutdown();
    }

    @Test
    public void testGetSecureClientAddress() throws IOException {
        ZooKeeperServer zks = new ZooKeeperServer();
        ZooKeeperServerBean serverBean = new ZooKeeperServerBean(zks);
        String result = serverBean.getSecureClientPort();
        Assert.assertEquals((Object)"", (Object)result);
        ServerCnxnFactory cnxnFactory = ServerCnxnFactory.createFactory();
        int secureClientPort = 8443;
        InetSocketAddress address = new InetSocketAddress(secureClientPort);
        cnxnFactory.configure(address, 5, -1, true);
        zks.setSecureServerCnxnFactory(cnxnFactory);
        result = serverBean.getSecureClientAddress();
        String ipv4 = "0.0.0.0:" + secureClientPort;
        String ipv6 = "0:0:0:0:0:0:0:0:" + secureClientPort;
        Assert.assertTrue((result.equals(ipv4) || result.equals(ipv6) ? 1 : 0) != 0);
        cnxnFactory.shutdown();
    }
}

