/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper;

import io.hops.hadoop.shaded.org.apache.zookeeper.SaslServerPrincipal;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.client.ZKClientConfig;
import io.hops.hadoop.shaded.org.mockito.Mockito;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.junit.Assert;
import org.junit.Test;

public class ClientCanonicalizeTest
extends ZKTestCase {
    @Test
    public void testClientCanonicalization() throws IOException, InterruptedException {
        SaslServerPrincipal.WrapperInetSocketAddress addr = Mockito.mock(SaslServerPrincipal.WrapperInetSocketAddress.class);
        SaslServerPrincipal.WrapperInetAddress ia = Mockito.mock(SaslServerPrincipal.WrapperInetAddress.class);
        Mockito.when(addr.getHostName()).thenReturn("zookeeper.apache.org");
        Mockito.when(addr.getAddress()).thenReturn(ia);
        Mockito.when(ia.getCanonicalHostName()).thenReturn("zk1.apache.org");
        Mockito.when(ia.getHostAddress()).thenReturn("127.0.0.1");
        ZKClientConfig conf = new ZKClientConfig();
        String principal = SaslServerPrincipal.getServerPrincipal(addr, conf);
        Assert.assertEquals((String)"The computed principal does not appear to have been canonicalized", (Object)"zookeeper/zk1.apache.org", (Object)principal);
    }

    @Test
    public void testClientNoCanonicalization() throws IOException, InterruptedException {
        SaslServerPrincipal.WrapperInetSocketAddress addr = Mockito.mock(SaslServerPrincipal.WrapperInetSocketAddress.class);
        SaslServerPrincipal.WrapperInetAddress ia = Mockito.mock(SaslServerPrincipal.WrapperInetAddress.class);
        Mockito.when(addr.getHostName()).thenReturn("zookeeper.apache.org");
        Mockito.when(addr.getAddress()).thenReturn(ia);
        Mockito.when(ia.getCanonicalHostName()).thenReturn("zk1.apache.org");
        Mockito.when(ia.getHostAddress()).thenReturn("127.0.0.1");
        ZKClientConfig conf = new ZKClientConfig();
        conf.setProperty("zookeeper.sasl.client.canonicalize.hostname", "false");
        String principal = SaslServerPrincipal.getServerPrincipal(addr, conf);
        Assert.assertEquals((String)"The computed principal does appears to have been canonicalized incorrectly", (Object)"zookeeper/zookeeper.apache.org", (Object)principal);
    }

    @Test
    public void testClientCanonicalizationToIp() throws IOException, InterruptedException {
        SaslServerPrincipal.WrapperInetSocketAddress addr = Mockito.mock(SaslServerPrincipal.WrapperInetSocketAddress.class);
        SaslServerPrincipal.WrapperInetAddress ia = Mockito.mock(SaslServerPrincipal.WrapperInetAddress.class);
        Mockito.when(addr.getHostName()).thenReturn("zookeeper.apache.org");
        Mockito.when(addr.getAddress()).thenReturn(ia);
        Mockito.when(ia.getCanonicalHostName()).thenReturn("127.0.0.1");
        Mockito.when(ia.getHostAddress()).thenReturn("127.0.0.1");
        ZKClientConfig conf = new ZKClientConfig();
        String principal = SaslServerPrincipal.getServerPrincipal(addr, conf);
        Assert.assertEquals((String)"The computed principal does appear to have falled back to the original host name", (Object)"zookeeper/zookeeper.apache.org", (Object)principal);
    }

    @Test
    public void testGetServerPrincipalReturnConfiguredPrincipalName() {
        ZKClientConfig config = new ZKClientConfig();
        String configuredPrincipal = "zookeeper/zookeeper.apache.org@APACHE.ORG";
        config.setProperty("zookeeper.server.principal", configuredPrincipal);
        String serverPrincipal = SaslServerPrincipal.getServerPrincipal((InetSocketAddress)null, config);
        Assert.assertEquals((Object)configuredPrincipal, (Object)serverPrincipal);
    }
}

