/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.mockito.internal.verification.checkers;

import io.hops.hadoop.shaded.org.mockito.exceptions.Reporter;
import io.hops.hadoop.shaded.org.mockito.internal.debugging.Location;
import io.hops.hadoop.shaded.org.mockito.internal.invocation.CapturesArgumensFromInvocation;
import io.hops.hadoop.shaded.org.mockito.internal.invocation.Invocation;
import io.hops.hadoop.shaded.org.mockito.internal.invocation.InvocationMarker;
import io.hops.hadoop.shaded.org.mockito.internal.invocation.InvocationMatcher;
import io.hops.hadoop.shaded.org.mockito.internal.invocation.InvocationsFinder;
import io.hops.hadoop.shaded.org.mockito.internal.verification.checkers.AtLeastDiscrepancy;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtLeastXNumberOfInvocationsChecker {
    Reporter reporter = new Reporter();
    InvocationsFinder finder = new InvocationsFinder();
    InvocationMarker invocationMarker = new InvocationMarker();

    public void check(List<Invocation> invocations, InvocationMatcher wanted, int wantedCount) {
        List<Invocation> actualInvocations = this.finder.findInvocations(invocations, wanted);
        int actualCount = actualInvocations.size();
        if (wantedCount > actualCount) {
            Location lastLocation = this.finder.getLastLocation(actualInvocations);
            this.reporter.tooLittleActualInvocations(new AtLeastDiscrepancy(wantedCount, actualCount), wanted, lastLocation);
        }
        this.invocationMarker.markVerified(actualInvocations, (CapturesArgumensFromInvocation)wanted);
    }
}

