/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.audit;

import io.hops.hadoop.shaded.org.apache.log4j.Appender;
import io.hops.hadoop.shaded.org.apache.log4j.Layout;
import io.hops.hadoop.shaded.org.apache.log4j.Level;
import io.hops.hadoop.shaded.org.apache.log4j.Logger;
import io.hops.hadoop.shaded.org.apache.log4j.Priority;
import io.hops.hadoop.shaded.org.apache.log4j.SimpleLayout;
import io.hops.hadoop.shaded.org.apache.log4j.WriterAppender;
import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.Op;
import io.hops.hadoop.shaded.org.apache.zookeeper.PortAssignment;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZKUtil;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.audit.AuditEvent;
import io.hops.hadoop.shaded.org.apache.zookeeper.audit.Log4jAuditLogger;
import io.hops.hadoop.shaded.org.apache.zookeeper.audit.ZKAuditProvider;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.ACL;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.Stat;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.Request;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerCnxn;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class Log4jAuditLoggerTest
extends QuorumPeerTestBase {
    private static final Logger LOG = Logger.getLogger(Log4jAuditLoggerTest.class);
    private static int SERVER_COUNT = 3;
    private static QuorumPeerTestBase.MainThread[] mt;
    private static ZooKeeper zk;
    private static Logger zlogger;
    private static WriterAppender appender;
    private static ByteArrayOutputStream os;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        System.setProperty("zookeeper.audit.enable", "true");
        SimpleLayout layout = new SimpleLayout();
        os = new ByteArrayOutputStream();
        appender = new WriterAppender((Layout)layout, (OutputStream)os);
        appender.setImmediateFlush(true);
        appender.setThreshold((Priority)Level.INFO);
        zlogger = Logger.getLogger(Log4jAuditLogger.class);
        zlogger.addAppender((Appender)appender);
        mt = Log4jAuditLoggerTest.startQuorum();
        zk = ClientBase.createZKClient("127.0.0.1:" + mt[0].getQuorumPeer().getClientPort());
        String expectedAuditLog = Log4jAuditLoggerTest.getStartLog();
        List<String> logs = Log4jAuditLoggerTest.readAuditLog(os, SERVER_COUNT);
        Log4jAuditLoggerTest.verifyLogs(expectedAuditLog, logs);
    }

    @Before
    public void setUp() {
        os.reset();
    }

    @Test
    public void testCreateAuditLogs() throws KeeperException, InterruptedException, IOException {
        String path = "/createPath";
        zk.create(path, "".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        String createMode = CreateMode.PERSISTENT.toString().toLowerCase();
        Log4jAuditLoggerTest.verifyLog(this.getAuditLog("create", path, AuditEvent.Result.SUCCESS, null, createMode), this.readAuditLog(os));
        try {
            zk.create(path, "".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (KeeperException exception) {
            KeeperException.Code code = exception.code();
            Assert.assertEquals((Object)KeeperException.Code.NODEEXISTS, (Object)code);
        }
        Log4jAuditLoggerTest.verifyLog(this.getAuditLog("create", path, AuditEvent.Result.FAILURE, null, createMode), this.readAuditLog(os));
    }

    @Test
    public void testDeleteAuditLogs() throws InterruptedException, IOException, KeeperException {
        String path = "/deletePath";
        zk.create(path, "".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        os.reset();
        try {
            zk.delete(path, -100);
        }
        catch (KeeperException exception) {
            KeeperException.Code code = exception.code();
            Assert.assertEquals((Object)KeeperException.Code.BADVERSION, (Object)code);
        }
        Log4jAuditLoggerTest.verifyLog(this.getAuditLog("delete", path, AuditEvent.Result.FAILURE), this.readAuditLog(os));
        zk.delete(path, -1);
        Log4jAuditLoggerTest.verifyLog(this.getAuditLog("delete", path), this.readAuditLog(os));
    }

    @Test
    public void testSetDataAuditLogs() throws InterruptedException, IOException, KeeperException {
        String path = "/setDataPath";
        zk.create(path, "".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        os.reset();
        try {
            zk.setData(path, "newData".getBytes(), -100);
        }
        catch (KeeperException exception) {
            KeeperException.Code code = exception.code();
            Assert.assertEquals((Object)KeeperException.Code.BADVERSION, (Object)code);
        }
        Log4jAuditLoggerTest.verifyLog(this.getAuditLog("setData", path, AuditEvent.Result.FAILURE), this.readAuditLog(os));
        zk.setData(path, "newdata".getBytes(), -1);
        Log4jAuditLoggerTest.verifyLog(this.getAuditLog("setData", path), this.readAuditLog(os));
    }

    @Test
    public void testSetACLAuditLogs() throws InterruptedException, IOException, KeeperException {
        ArrayList<ACL> openAclUnsafe = ZooDefs.Ids.OPEN_ACL_UNSAFE;
        String path = "/aclPath";
        zk.create(path, "".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        os.reset();
        try {
            zk.setACL(path, openAclUnsafe, -100);
        }
        catch (KeeperException exception) {
            KeeperException.Code code = exception.code();
            Assert.assertEquals((Object)KeeperException.Code.BADVERSION, (Object)code);
        }
        Log4jAuditLoggerTest.verifyLog(this.getAuditLog("setAcl", path, AuditEvent.Result.FAILURE, ZKUtil.aclToString(openAclUnsafe), null), this.readAuditLog(os));
        zk.setACL(path, openAclUnsafe, -1);
        Log4jAuditLoggerTest.verifyLog(this.getAuditLog("setAcl", path, AuditEvent.Result.SUCCESS, ZKUtil.aclToString(openAclUnsafe), null), this.readAuditLog(os));
    }

    @Test
    public void testMultiOperationAuditLogs() throws InterruptedException, KeeperException, IOException {
        ArrayList<Op> ops = new ArrayList<Op>();
        String multiop = "/b";
        Op create = Op.create(multiop, "".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Op setData = Op.setData(multiop, "newData".getBytes(), -1);
        Op check = Op.check(multiop, -1);
        Op delete = Op.delete(multiop, -1);
        String createMode = CreateMode.PERSISTENT.toString().toLowerCase();
        ops.add(create);
        ops.add(setData);
        ops.add(check);
        ops.add(delete);
        zk.multi(ops);
        List<String> multiOpLogs = Log4jAuditLoggerTest.readAuditLog(os, 3);
        Log4jAuditLoggerTest.verifyLog(this.getAuditLog("create", multiop, AuditEvent.Result.SUCCESS, null, createMode), multiOpLogs.get(0));
        Log4jAuditLoggerTest.verifyLog(this.getAuditLog("setData", multiop), multiOpLogs.get(1));
        Log4jAuditLoggerTest.verifyLog(this.getAuditLog("delete", multiop), multiOpLogs.get(2));
        ops = new ArrayList();
        ops.add(create);
        ops.add(create);
        try {
            zk.multi(ops);
        }
        catch (KeeperException exception) {
            KeeperException.Code code = exception.code();
            Assert.assertEquals((Object)KeeperException.Code.NODEEXISTS, (Object)code);
        }
        Log4jAuditLoggerTest.verifyLog(this.getAuditLog("multiOperation", null, AuditEvent.Result.FAILURE), this.readAuditLog(os));
    }

    @Test
    public void testEphemralZNodeAuditLogs() throws Exception {
        String ephemralPath = "/ephemral";
        ClientBase.CountdownWatcher watcher2 = new ClientBase.CountdownWatcher();
        ZooKeeper zk2 = new ZooKeeper("127.0.0.1:" + mt[0].getQuorumPeer().getClientPort(), ClientBase.CONNECTION_TIMEOUT, watcher2);
        watcher2.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        zk2.create(ephemralPath, "".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        String session2 = "0x" + Long.toHexString(zk2.getSessionId());
        Log4jAuditLoggerTest.verifyLog(this.getAuditLog("create", ephemralPath, AuditEvent.Result.SUCCESS, null, CreateMode.EPHEMERAL.toString().toLowerCase(), session2), this.readAuditLog(os));
        zk2.close();
        this.waitForDeletion(zk, ephemralPath);
        Log4jAuditLoggerTest.verifyLogs(this.getAuditLog("ephemeralZNodeDeletionOnSessionCloseOrExpire", ephemralPath, AuditEvent.Result.SUCCESS, null, null, session2, ZKAuditProvider.getZKUser(), null), Log4jAuditLoggerTest.readAuditLog(os, SERVER_COUNT));
    }

    private static String getStartLog() {
        AuditEvent logEvent = ZKAuditProvider.createLogEvent(ZKAuditProvider.getZKUser(), "serverStart", AuditEvent.Result.SUCCESS);
        return logEvent.toString();
    }

    private String getAuditLog(String operation, String znode) {
        return this.getAuditLog(operation, znode, AuditEvent.Result.SUCCESS);
    }

    private String getAuditLog(String operation, String znode, AuditEvent.Result result) {
        return this.getAuditLog(operation, znode, result, null, null);
    }

    private String getAuditLog(String operation, String znode, AuditEvent.Result result, String acl, String createMode) {
        String session = this.getSession();
        return this.getAuditLog(operation, znode, result, acl, createMode, session);
    }

    private String getAuditLog(String operation, String znode, AuditEvent.Result result, String acl, String createMode, String session) {
        String user = this.getUser();
        String ip = this.getIp();
        return this.getAuditLog(operation, znode, result, acl, createMode, session, user, ip);
    }

    private String getAuditLog(String operation, String znode, AuditEvent.Result result, String acl, String createMode, String session, String user, String ip) {
        AuditEvent logEvent = ZKAuditProvider.createLogEvent(user, operation, znode, acl, createMode, session, ip, result);
        String auditLog = logEvent.toString();
        LOG.info((Object)("expected audit log for operation '" + operation + "' is '" + auditLog + "'"));
        return auditLog;
    }

    private String getSession() {
        return "0x" + Long.toHexString(zk.getSessionId());
    }

    private String getUser() {
        ServerCnxn next = this.getServerCnxn();
        Request request = new Request(next, -1L, -1, -1, null, next.getAuthInfo());
        return request.getUsers();
    }

    private String getIp() {
        ServerCnxn next = this.getServerCnxn();
        InetSocketAddress remoteSocketAddress = next.getRemoteSocketAddress();
        InetAddress address = remoteSocketAddress.getAddress();
        return address.getHostAddress();
    }

    private ServerCnxn getServerCnxn() {
        Iterable<ServerCnxn> connections = mt[0].getQuorumPeer().getActiveServer().getServerCnxnFactory().getConnections();
        return connections.iterator().next();
    }

    private static void verifyLog(String expectedLog, String log) {
        String searchString = " - ";
        int logStartIndex = log.indexOf(searchString);
        String auditLog = log.substring(logStartIndex + searchString.length());
        Assert.assertEquals((Object)expectedLog, (Object)auditLog);
    }

    private static void verifyLogs(String expectedLog, List<String> logs) {
        for (String log : logs) {
            Log4jAuditLoggerTest.verifyLog(expectedLog, log);
        }
    }

    private String readAuditLog(ByteArrayOutputStream os) throws IOException {
        return Log4jAuditLoggerTest.readAuditLog(os, 1).get(0);
    }

    private static List<String> readAuditLog(ByteArrayOutputStream os, int numberOfLogEntry) throws IOException {
        return Log4jAuditLoggerTest.readAuditLog(os, numberOfLogEntry, false);
    }

    private static List<String> readAuditLog(ByteArrayOutputStream os, int numberOfLogEntry, boolean skipEphemralDeletion) throws IOException {
        String line;
        ArrayList<String> logs = new ArrayList<String>();
        LineNumberReader r = new LineNumberReader(new StringReader(os.toString()));
        while ((line = r.readLine()) != null) {
            if (skipEphemralDeletion && line.contains("ephemeralZNodeDeletionOnSessionCloseOrExpire")) continue;
            logs.add(line);
        }
        os.reset();
        Assert.assertEquals((String)("Expected number of log entries are not generated. Logs are " + logs), (long)numberOfLogEntry, (long)logs.size());
        return logs;
    }

    private static QuorumPeerTestBase.MainThread[] startQuorum() throws IOException {
        int i;
        int[] clientPorts = new int[SERVER_COUNT];
        StringBuilder sb = new StringBuilder();
        sb.append("4lw.commands.whitelist=*");
        sb.append("\n");
        for (int i2 = 0; i2 < SERVER_COUNT; ++i2) {
            clientPorts[i2] = PortAssignment.unique();
            String server = "server." + i2 + "=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":participant;127.0.0.1:" + clientPorts[i2];
            sb.append(server);
            sb.append("\n");
        }
        String currentQuorumCfgSection = sb.toString();
        QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[SERVER_COUNT];
        for (i = 0; i < SERVER_COUNT; ++i) {
            mt[i] = new QuorumPeerTestBase.MainThread(i, clientPorts[i], currentQuorumCfgSection, false);
            mt[i].start();
        }
        for (i = 0; i < SERVER_COUNT; ++i) {
            Assert.assertTrue((String)("waiting for server " + i + " being up"), (boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[i], ClientBase.CONNECTION_TIMEOUT));
        }
        return mt;
    }

    private void waitForDeletion(ZooKeeper zooKeeper, String path) throws Exception {
        long waitInterval = 10L;
        int timeout = 100;
        Stat exists = zooKeeper.exists(path, false);
        for (long elapsedTime = 0L; exists != null && elapsedTime < (long)timeout; elapsedTime += waitInterval) {
            try {
                Thread.sleep(waitInterval);
            }
            catch (InterruptedException e) {
                Assert.fail((String)"CurrentEpoch update failed");
            }
            exists = zooKeeper.exists(path, false);
        }
        Assert.assertNull((String)("Node " + path + " not deleted in " + timeout + " ms"), (Object)exists);
    }

    @AfterClass
    public static void tearDownAfterClass() {
        System.clearProperty("zookeeper.audit.enable");
        for (int i = 0; i < SERVER_COUNT; ++i) {
            try {
                if (mt[i] == null) continue;
                mt[i].shutdown();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            zlogger.removeAppender((Appender)appender);
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

