/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum;

import io.hops.hadoop.shaded.org.apache.zookeeper.PortAssignment;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.X509Exception;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerCnxn;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerCnxnFactory;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZKDatabase;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.Leader;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.flexible.QuorumMaj;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;

public class ZabUtils {
    public static final int SYNC_LIMIT = 2;

    private ZabUtils() {
    }

    public static QuorumPeer createQuorumPeer(File tmpDir) throws IOException {
        HashMap<Long, QuorumPeer.QuorumServer> peers = new HashMap<Long, QuorumPeer.QuorumServer>();
        QuorumPeer peer = QuorumPeer.testingQuorumPeer();
        peer.syncLimit = 2;
        peer.initLimit = 2;
        peer.tickTime = 2000;
        peers.put(0L, new QuorumPeer.QuorumServer(0L, new InetSocketAddress("127.0.0.1", PortAssignment.unique()), new InetSocketAddress("127.0.0.1", PortAssignment.unique()), new InetSocketAddress("127.0.0.1", PortAssignment.unique())));
        peers.put(1L, new QuorumPeer.QuorumServer(1L, new InetSocketAddress("127.0.0.1", PortAssignment.unique()), new InetSocketAddress("127.0.0.1", PortAssignment.unique()), new InetSocketAddress("127.0.0.1", PortAssignment.unique())));
        peers.put(2L, new QuorumPeer.QuorumServer(2L, new InetSocketAddress("127.0.0.1", PortAssignment.unique()), new InetSocketAddress("127.0.0.1", PortAssignment.unique()), new InetSocketAddress("127.0.0.1", PortAssignment.unique())));
        peer.setQuorumVerifier(new QuorumMaj(peers), false);
        peer.setCnxnFactory(new NullServerCnxnFactory());
        File version2 = new File(tmpDir, "version-2");
        version2.mkdir();
        ClientBase.createInitializeFile(tmpDir);
        FileOutputStream fos = new FileOutputStream(new File(version2, "currentEpoch"));
        fos.write("0\n".getBytes());
        fos.close();
        fos = new FileOutputStream(new File(version2, "acceptedEpoch"));
        fos.write("0\n".getBytes());
        fos.close();
        return peer;
    }

    public static Leader createLeader(File tmpDir, QuorumPeer peer) throws IOException, NoSuchFieldException, IllegalAccessException, X509Exception {
        LeaderZooKeeperServer zk = ZabUtils.prepareLeader(tmpDir, peer);
        return new Leader(peer, zk);
    }

    public static Leader createMockLeader(File tmpDir, QuorumPeer peer) throws IOException, NoSuchFieldException, IllegalAccessException, X509Exception {
        LeaderZooKeeperServer zk = ZabUtils.prepareLeader(tmpDir, peer);
        return new MockLeader(peer, zk);
    }

    private static LeaderZooKeeperServer prepareLeader(File tmpDir, QuorumPeer peer) throws IOException, NoSuchFieldException, IllegalAccessException {
        FileTxnSnapLog logFactory = new FileTxnSnapLog(tmpDir, tmpDir);
        peer.setTxnFactory(logFactory);
        ZKDatabase zkDb = new ZKDatabase(logFactory);
        LeaderZooKeeperServer zk = new LeaderZooKeeperServer(logFactory, peer, zkDb);
        return zk;
    }

    public static final class MockLeader
    extends Leader {
        MockLeader(QuorumPeer qp, LeaderZooKeeperServer zk) throws IOException, X509Exception {
            super(qp, zk);
        }

        public long getCurrentEpochToPropose() {
            return this.epoch;
        }
    }

    private static final class NullServerCnxnFactory
    extends ServerCnxnFactory {
        private NullServerCnxnFactory() {
        }

        @Override
        public void startup(ZooKeeperServer zkServer, boolean startServer) throws IOException, InterruptedException {
        }

        @Override
        public void start() {
        }

        @Override
        public void shutdown() {
        }

        @Override
        public void setMaxClientCnxnsPerHost(int max) {
        }

        @Override
        public void join() throws InterruptedException {
        }

        @Override
        public int getMaxClientCnxnsPerHost() {
            return 0;
        }

        @Override
        public int getSocketListenBacklog() {
            return -1;
        }

        @Override
        public int getLocalPort() {
            return 0;
        }

        @Override
        public InetSocketAddress getLocalAddress() {
            return null;
        }

        @Override
        public Iterable<ServerCnxn> getConnections() {
            return null;
        }

        @Override
        public void configure(InetSocketAddress addr, int maxcc, int listenBacklog, boolean secure) throws IOException {
        }

        @Override
        public boolean closeSession(long sessionId, ServerCnxn.DisconnectReason reason) {
            return false;
        }

        @Override
        public void closeAll(ServerCnxn.DisconnectReason reason) {
        }

        @Override
        public int getNumAliveConnections() {
            return 0;
        }

        @Override
        public void reconfigure(InetSocketAddress addr) {
        }

        @Override
        public void resetAllConnectionStats() {
        }

        @Override
        public Iterable<Map<String, Object>> getAllConnectionInfo(boolean brief) {
            return null;
        }
    }
}

