/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.jute.Record;
import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.PortAssignment;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.Stat;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerCnxnFactory;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.SyncRequestProcessor;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.TxnLogEntry;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZKDatabase;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.Leader;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.util.SerializeUtils;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.txn.TxnHeader;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;

public class GetProposalFromTxnTest
extends ZKTestCase {
    private static String HOSTPORT = "127.0.0.1:" + PortAssignment.unique();
    private static final int CONNECTION_TIMEOUT = 3000;
    private static final int MSG_COUNT = 2000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetProposalFromTxn() throws Exception {
        File tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        SyncRequestProcessor.setSnapCount(100);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory(PORT, -1);
        f.startup(zks);
        Assert.assertTrue((String)"waiting for server being up ", (boolean)ClientBase.waitForServerUp(HOSTPORT, 3000L));
        Object[] zxids = new Long[2000];
        try (ZooKeeper zk = ClientBase.createZKClient(HOSTPORT);){
            String data = "data";
            byte[] bytes = data.getBytes();
            for (int i = 0; i < 2000; ++i) {
                Stat stat = new Stat();
                zk.create("/invalidsnap-" + i, bytes, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                zk.getData("/invalidsnap-" + i, null, stat);
                zxids[i] = stat.getCzxid();
            }
        }
        f.shutdown();
        zks.shutdown();
        Assert.assertTrue((String)"waiting for server to shutdown", (boolean)ClientBase.waitForServerDown(HOSTPORT, 3000L));
        zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        zks.startdata();
        ZKDatabase db = zks.getZKDatabase();
        Iterator<Leader.Proposal> itr = db.getProposalsFromTxnLog(zxids[0], 10000000L);
        int createCount = 0;
        ArrayList<Long> retrievedZxids = new ArrayList<Long>(2000);
        while (itr.hasNext()) {
            Leader.Proposal proposal = itr.next();
            TxnLogEntry logEntry = SerializeUtils.deserializeTxn(proposal.packet.getData());
            TxnHeader hdr = logEntry.getHeader();
            Record rec = logEntry.getTxn();
            if (hdr.getType() != 1) continue;
            retrievedZxids.add(hdr.getZxid());
            ++createCount;
        }
        Assert.assertTrue((String)"Zxids missmatches", (boolean)Arrays.equals(zxids, (Object[])retrievedZxids.toArray(new Long[0])));
        Assert.assertTrue((String)"create proposal count == 2000", (createCount == 2000 ? 1 : 0) != 0);
        db.setSnapshotSizeFactor(0.33);
        long sizeLimit = db.calculateTxnLogSizeLimit();
        itr = db.getProposalsFromTxnLog((Long)zxids[1000], sizeLimit);
        Assert.assertFalse((String)"Expect empty proposal", (boolean)itr.hasNext());
        f.shutdown();
        zks.shutdown();
    }
}

