/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.Leader;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientTest;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.JMXEnv;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.QuorumBase;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuorumMajorityTest
extends QuorumBase {
    protected static final Logger LOG = LoggerFactory.getLogger(QuorumMajorityTest.class);
    public static final long CONNECTION_TIMEOUT = ClientTest.CONNECTION_TIMEOUT;

    @Test
    public void testMajQuorums() throws Throwable {
        LOG.info("Verify QuorumPeer#electionTimeTaken jmx bean attribute");
        ArrayList<QuorumPeer> peers = this.getPeerList();
        for (int i = 1; i <= peers.size(); ++i) {
            QuorumPeer qp = peers.get(i - 1);
            Long electionTimeTaken = -1L;
            String bean = "";
            if (qp.getPeerState() == QuorumPeer.ServerState.FOLLOWING) {
                bean = String.format("%s:name0=ReplicatedServer_id%d,name1=replica.%d,name2=Follower", "io.hops.hadoop.shaded.org.apache.ZooKeeperService", i, i);
            } else if (qp.getPeerState() == QuorumPeer.ServerState.LEADING) {
                bean = String.format("%s:name0=ReplicatedServer_id%d,name1=replica.%d,name2=Leader", "io.hops.hadoop.shaded.org.apache.ZooKeeperService", i, i);
            }
            electionTimeTaken = (Long)JMXEnv.ensureBeanAttribute(bean, "ElectionTimeTaken");
            Assert.assertTrue((String)"Wrong electionTimeTaken value!", (electionTimeTaken >= 0L ? 1 : 0) != 0);
        }
        this.setUp(false);
        Leader.Proposal p = new Leader.Proposal();
        p.addQuorumVerifier(this.s1.getQuorumVerifier());
        p.addAck(1L);
        p.addAck(2L);
        Assert.assertEquals((Object)false, (Object)p.hasAllQuorums());
        p.addAck(6L);
        Assert.assertEquals((Object)false, (Object)p.hasAllQuorums());
        p.addAck(3L);
        Assert.assertEquals((Object)true, (Object)p.hasAllQuorums());
        this.setUp(true);
        p = new Leader.Proposal();
        p.addQuorumVerifier(this.s1.getQuorumVerifier());
        p.addAck(1L);
        Assert.assertEquals((Object)false, (Object)p.hasAllQuorums());
        p.addAck(4L);
        p.addAck(5L);
        Assert.assertEquals((Object)false, (Object)p.hasAllQuorums());
        p.addAck(6L);
        Assert.assertEquals((Object)false, (Object)p.hasAllQuorums());
        p.addAck(2L);
        Assert.assertEquals((Object)true, (Object)p.hasAllQuorums());
    }
}

