/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.terracotta.statistics;

import io.hops.hadoop.shaded.org.terracotta.statistics.AbstractOperationStatistic;
import io.hops.hadoop.shaded.org.terracotta.statistics.OperationStatistic;
import io.hops.hadoop.shaded.org.terracotta.statistics.Time;
import io.hops.hadoop.shaded.org.terracotta.statistics.jsr166e.LongAdder;
import io.hops.hadoop.shaded.org.terracotta.statistics.observer.ChainedOperationObserver;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;

class GeneralOperationStatistic<T extends Enum<T>>
extends AbstractOperationStatistic<T>
implements OperationStatistic<T> {
    private final EnumMap<T, LongAdder> counts;

    GeneralOperationStatistic(String name, Set<String> tags, Map<String, ? extends Object> properties, Class<T> type) {
        super(name, tags, properties, type);
        this.counts = new EnumMap(type);
        for (Enum t : (Enum[])type.getEnumConstants()) {
            this.counts.put(t, new LongAdder());
        }
    }

    @Override
    public long count(T type) {
        return this.counts.get(type).sum();
    }

    @Override
    public long sum(Set<T> types) {
        long sum = 0L;
        for (Enum t : types) {
            sum += this.counts.get(t).sum();
        }
        return sum;
    }

    @Override
    public void end(T result) {
        this.counts.get(result).increment();
        if (!this.derivedStatistics.isEmpty()) {
            long time = Time.time();
            for (ChainedOperationObserver observer : this.derivedStatistics) {
                observer.end(time, result);
            }
        }
    }

    @Override
    public void end(T result, long ... parameters) {
        this.counts.get(result).increment();
        if (!this.derivedStatistics.isEmpty()) {
            long time = Time.time();
            for (ChainedOperationObserver observer : this.derivedStatistics) {
                observer.end(time, result, parameters);
            }
        }
    }

    public String toString() {
        return this.counts.toString();
    }
}

