/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.PortAssignment;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class EpochWriteFailureTest
extends QuorumPeerTestBase {
    private static int SERVER_COUNT = 3;
    private static int[] clientPorts = new int[SERVER_COUNT];
    private static QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[SERVER_COUNT];
    private static ZooKeeper zk;

    @Test(timeout=120000L)
    public void testAcceptedEpochWriteFailure() throws Exception {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("admin.enableServer=false");
        sb.append("\n");
        for (int i2 = 0; i2 < SERVER_COUNT; ++i2) {
            EpochWriteFailureTest.clientPorts[i2] = PortAssignment.unique();
            String server = "server." + i2 + "=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":participant;127.0.0.1:" + clientPorts[i2];
            sb.append(server);
            sb.append("\n");
        }
        String currentQuorumCfgSection = sb.toString();
        for (i = 0; i < SERVER_COUNT - 1; ++i) {
            EpochWriteFailureTest.mt[i] = new QuorumPeerTestBase.MainThread(i, clientPorts[i], currentQuorumCfgSection, false);
            mt[i].start();
        }
        for (i = 0; i < SERVER_COUNT - 1; ++i) {
            Assert.assertTrue((String)("waiting for server " + i + " being up"), (boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[i], ClientBase.CONNECTION_TIMEOUT));
        }
        ClientBase.CountdownWatcher watch1 = new ClientBase.CountdownWatcher();
        zk = new ZooKeeper("127.0.0.1:" + clientPorts[0], ClientBase.CONNECTION_TIMEOUT, watch1);
        watch1.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        String data = "originalData";
        zk.create("/epochIssue", data.getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        EpochWriteFailureTest.mt[2] = new QuorumPeerTestBase.MainThread(2, clientPorts[2], currentQuorumCfgSection, false){

            @Override
            public QuorumPeerTestBase.TestQPMain getTestQPMain() {
                return new MockTestQPMain();
            }
        };
        mt[2].start();
        Assert.assertFalse((String)"verify server 2 not started", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[2], ClientBase.CONNECTION_TIMEOUT / 2));
        QuorumPeer quorumPeer = mt[2].getQuorumPeer();
        Assert.assertEquals((String)"acceptedEpoch must not have changed", (long)0L, (long)quorumPeer.getAcceptedEpoch());
        Assert.assertEquals((String)"currentEpoch must not have changed", (long)0L, (long)quorumPeer.getCurrentEpoch());
    }

    @AfterClass
    public static void tearDownAfterClass() throws InterruptedException {
        for (int i = 0; i < SERVER_COUNT; ++i) {
            if (mt[i] == null) continue;
            mt[i].shutdown();
        }
        if (zk != null) {
            zk.close();
        }
    }

    private static class MockTestQPMain
    extends QuorumPeerTestBase.TestQPMain {
        private MockTestQPMain() {
        }

        @Override
        public void runFromConfig(QuorumPeerConfig config) throws IOException {
            this.quorumPeer = new CustomQuorumPeer(config.getQuorumVerifier().getAllMembers(), config.getDataDir(), config.getDataLogDir(), config.getClientPortAddress().getPort(), config.getElectionAlg(), config.getServerId(), config.getTickTime(), config.getInitLimit(), config.getSyncLimit(), config.getSyncLimit());
            this.quorumPeer.start();
            try {
                this.quorumPeer.join();
            }
            catch (InterruptedException e) {
                QuorumPeerTestBase.LOG.warn("Quorum Peer interrupted", (Throwable)e);
            }
        }
    }

    static class CustomQuorumPeer
    extends QuorumPeer {
        CustomQuorumPeer(Map<Long, QuorumPeer.QuorumServer> quorumPeers, File snapDir, File logDir, int clientPort, int electionAlg, long myid, int tickTime, int initLimit, int syncLimit, int connectToLearnerMasterLimit) throws IOException {
            super(quorumPeers, snapDir, logDir, clientPort, electionAlg, myid, tickTime, initLimit, syncLimit, connectToLearnerMasterLimit);
        }

        @Override
        protected void writeLongToFile(String name, long value) throws IOException {
            if (0L != value) {
                throw new IOException("Input/output error");
            }
        }
    }
}

