/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.PortAssignment;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.ClientX509Util;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ClientSSLTest
extends QuorumPeerTestBase {
    private ClientX509Util clientX509Util;
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();

    @Before
    public void setup() {
        System.setProperty("zookeeper.client.portUnification", Boolean.TRUE.toString());
        this.clientX509Util = new ClientX509Util();
        String testDataPath = System.getProperty("test.data.dir", "src/test/resources/data");
        System.setProperty("zookeeper.serverCnxnFactory", "io.hops.hadoop.shaded.org.apache.zookeeper.server.NettyServerCnxnFactory");
        System.setProperty("zookeeper.clientCnxnSocket", "io.hops.hadoop.shaded.org.apache.zookeeper.ClientCnxnSocketNetty");
        System.setProperty("zookeeper.client.secure", "true");
        System.setProperty(this.clientX509Util.getSslKeystoreLocationProperty(), testDataPath + "/ssl/testKeyStore.jks");
        System.setProperty(this.clientX509Util.getSslKeystorePasswdProperty(), "testpass");
        System.setProperty(this.clientX509Util.getSslTruststoreLocationProperty(), testDataPath + "/ssl/testTrustStore.jks");
        System.setProperty(this.clientX509Util.getSslTruststorePasswdProperty(), "testpass");
    }

    @After
    public void teardown() {
        System.clearProperty("zookeeper.client.portUnification");
        System.clearProperty("zookeeper.serverCnxnFactory");
        System.clearProperty("zookeeper.clientCnxnSocket");
        System.clearProperty("zookeeper.client.secure");
        System.clearProperty(this.clientX509Util.getSslKeystoreLocationProperty());
        System.clearProperty(this.clientX509Util.getSslKeystorePasswdProperty());
        System.clearProperty(this.clientX509Util.getSslTruststoreLocationProperty());
        System.clearProperty(this.clientX509Util.getSslTruststorePasswdProperty());
        this.clientX509Util.close();
    }

    @Test
    public void testClientServerUnifiedPort() throws Exception {
        this.testClientServerSSL(false);
    }

    @Test
    public void testClientServerSSL() throws Exception {
        this.testClientServerSSL(true);
    }

    public void testClientServerSSL(boolean useSecurePort) throws Exception {
        int i;
        int SERVER_COUNT = 3;
        int[] clientPorts = new int[3];
        Integer[] secureClientPorts = new Integer[3];
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < 3; ++i2) {
            clientPorts[i2] = PortAssignment.unique();
            secureClientPorts[i2] = PortAssignment.unique();
            String server = String.format("server.%d=127.0.0.1:%d:%d:participant;127.0.0.1:%d%n", i2, PortAssignment.unique(), PortAssignment.unique(), clientPorts[i2]);
            sb.append(server);
        }
        String quorumCfg = sb.toString();
        QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[3];
        for (i = 0; i < 3; ++i) {
            mt[i] = useSecurePort ? new QuorumPeerTestBase.MainThread(i, quorumCfg, secureClientPorts[i], true) : new QuorumPeerTestBase.MainThread(i, quorumCfg, true);
            mt[i].start();
        }
        ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[0], 10000L);
        for (i = 0; i < 3; ++i) {
            Assert.assertTrue((String)("waiting for server " + i + " being up"), (boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[i], 5000L));
            int port = useSecurePort ? secureClientPorts[i] : clientPorts[i];
            ZooKeeper zk = ClientBase.createZKClient("127.0.0.1:" + port, 5000);
            zk.create("/test", "".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            zk.delete("/test", -1);
            zk.close();
        }
        for (i = 0; i < mt.length; ++i) {
            mt[i].shutdown();
        }
    }

    @Test
    public void testSecureStandaloneServer() throws Exception {
        Integer secureClientPort = PortAssignment.unique();
        QuorumPeerTestBase.MainThread mt = new QuorumPeerTestBase.MainThread(-1, "", secureClientPort, false);
        mt.start();
        ZooKeeper zk = ClientBase.createZKClient("127.0.0.1:" + secureClientPort, 5000);
        zk.create("/test", "".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.delete("/test", -1);
        zk.close();
        mt.shutdown();
    }

    @Test
    public void testSecureStandaloneServerAuthFail() throws IOException {
        this.exceptionRule.expect(AssertionError.class);
        this.exceptionRule.expectMessage("ZooKeeper client can not connect");
        try {
            System.setProperty("zookeeper.authProvider.authfail", "io.hops.hadoop.shaded.org.apache.zookeeper.test.AuthFailX509AuthenticationProvider");
            System.setProperty(this.clientX509Util.getSslAuthProviderProperty(), "authfail");
            Integer secureClientPort = PortAssignment.unique();
            QuorumPeerTestBase.MainThread mt = new QuorumPeerTestBase.MainThread(-1, "", secureClientPort, false);
            mt.start();
            ClientBase.createZKClient("localhost:" + secureClientPort, 5000, 3000L);
            Assert.fail((String)"Client should not able to connect to this server, because auth failed");
        }
        finally {
            System.clearProperty("zookeeper.authProvider.authfail");
            System.clearProperty(this.clientX509Util.getSslAuthProviderProperty());
        }
    }
}

