/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.glassfish.grizzly;

import io.hops.hadoop.shaded.org.glassfish.grizzly.Cacheable;
import io.hops.hadoop.shaded.org.glassfish.grizzly.CompletionHandler;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Connection;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Grizzly;
import io.hops.hadoop.shaded.org.glassfish.grizzly.IOEvent;
import io.hops.hadoop.shaded.org.glassfish.grizzly.IOEventProcessingHandler;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Processor;
import io.hops.hadoop.shaded.org.glassfish.grizzly.ProcessorResult;
import io.hops.hadoop.shaded.org.glassfish.grizzly.ThreadCache;
import io.hops.hadoop.shaded.org.glassfish.grizzly.asyncqueue.PushBackHandler;
import io.hops.hadoop.shaded.org.glassfish.grizzly.attributes.AttributeHolder;
import io.hops.hadoop.shaded.org.glassfish.grizzly.attributes.AttributeStorage;
import io.hops.hadoop.shaded.org.glassfish.grizzly.attributes.IndexedAttributeHolder;
import java.io.IOException;
import java.util.logging.Logger;

public class Context
implements AttributeStorage,
Cacheable {
    private static final Logger LOGGER = Grizzly.logger(Context.class);
    private static final Processor NULL_PROCESSOR = new NullProcessor();
    private static final ThreadCache.CachedTypeIndex<Context> CACHE_IDX = ThreadCache.obtainIndex(Context.class, 4);
    private Connection connection;
    protected IOEvent ioEvent = IOEvent.NONE;
    private Processor processor;
    private final AttributeHolder attributes = new IndexedAttributeHolder(Grizzly.DEFAULT_ATTRIBUTE_BUILDER);
    protected IOEventProcessingHandler processingHandler;
    protected boolean wasSuspended;
    protected boolean isManualIOEventControl;

    public static Context create(Connection connection) {
        Context context = ThreadCache.takeFromCache(CACHE_IDX);
        if (context == null) {
            context = new Context();
        }
        context.setConnection(connection);
        return context;
    }

    public static Context create(Connection connection, Processor processor, IOEvent ioEvent, IOEventProcessingHandler processingHandler) {
        Object context = processor != null ? processor.obtainContext(connection) : NULL_PROCESSOR.obtainContext(connection);
        ((Context)context).setIoEvent(ioEvent);
        ((Context)context).setProcessingHandler(processingHandler);
        return context;
    }

    public void suspend() {
        this.wasSuspended = true;
        IOEventProcessingHandler processingHandlerLocal = this.processingHandler;
        if (processingHandlerLocal != null) {
            try {
                processingHandlerLocal.onContextSuspend(this);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public void resume() {
        IOEventProcessingHandler processingHandlerLocal = this.processingHandler;
        if (processingHandlerLocal != null) {
            try {
                processingHandlerLocal.onContextResume(this);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public boolean wasSuspended() {
        return this.wasSuspended;
    }

    public void setManualIOEventControl() {
        this.isManualIOEventControl = true;
        IOEventProcessingHandler processingHandlerLocal = this.processingHandler;
        if (processingHandlerLocal != null) {
            try {
                processingHandlerLocal.onContextManualIOEventControl(this);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public boolean isManualIOEventControl() {
        return this.isManualIOEventControl;
    }

    public IOEvent getIoEvent() {
        return this.ioEvent;
    }

    public void setIoEvent(IOEvent ioEvent) {
        this.ioEvent = ioEvent;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public void setProcessor(Processor processor) {
        this.processor = processor;
    }

    public IOEventProcessingHandler getProcessingHandler() {
        return this.processingHandler;
    }

    public void setProcessingHandler(IOEventProcessingHandler processingHandler) {
        this.processingHandler = processingHandler;
    }

    @Override
    public AttributeHolder getAttributes() {
        return this.attributes;
    }

    public void reset() {
        this.attributes.recycle();
        this.processor = null;
        this.processingHandler = null;
        this.connection = null;
        this.ioEvent = IOEvent.NONE;
        this.wasSuspended = false;
        this.isManualIOEventControl = false;
    }

    @Override
    public void recycle() {
        this.reset();
        ThreadCache.putToCache(CACHE_IDX, this);
    }

    private static final class NullProcessor
    implements Processor {
        private NullProcessor() {
        }

        public Context obtainContext(Connection connection) {
            Context context = Context.create(connection);
            context.setProcessor(this);
            return context;
        }

        public ProcessorResult process(Context context) {
            return ProcessorResult.createNotRun();
        }

        public void read(Connection connection, CompletionHandler completionHandler) {
            throw new UnsupportedOperationException("Not supported.");
        }

        public void write(Connection connection, Object dstAddress, Object message, CompletionHandler completionHandler, PushBackHandler pushBackHandler) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean isInterested(IOEvent ioEvent) {
            return true;
        }

        @Override
        public void setInterested(IOEvent ioEvent, boolean isInterested) {
        }
    }
}

