/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.glassfish.grizzly.streams;

import io.hops.hadoop.shaded.org.glassfish.grizzly.Buffer;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Connection;
import io.hops.hadoop.shaded.org.glassfish.grizzly.EmptyCompletionHandler;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Grizzly;
import io.hops.hadoop.shaded.org.glassfish.grizzly.TransformationException;
import io.hops.hadoop.shaded.org.glassfish.grizzly.TransformationResult;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Transformer;
import io.hops.hadoop.shaded.org.glassfish.grizzly.attributes.Attribute;
import io.hops.hadoop.shaded.org.glassfish.grizzly.attributes.AttributeStorage;
import io.hops.hadoop.shaded.org.glassfish.grizzly.memory.CompositeBuffer;
import io.hops.hadoop.shaded.org.glassfish.grizzly.memory.MemoryManager;
import io.hops.hadoop.shaded.org.glassfish.grizzly.streams.BufferedInput;
import io.hops.hadoop.shaded.org.glassfish.grizzly.streams.Input;
import io.hops.hadoop.shaded.org.glassfish.grizzly.utils.conditions.Condition;
import java.io.IOException;

public final class TransformerInput
extends BufferedInput {
    private final Attribute<CompositeBuffer> inputBufferAttr;
    protected final Transformer<Buffer, Buffer> transformer;
    protected final Input underlyingInput;
    protected final MemoryManager memoryManager;
    protected final AttributeStorage attributeStorage;

    public TransformerInput(Transformer<Buffer, Buffer> transformer, Input underlyingInput, Connection connection) {
        this(transformer, underlyingInput, connection.getTransport().getMemoryManager(), connection);
    }

    public TransformerInput(Transformer<Buffer, Buffer> transformer, Input underlyingInput, MemoryManager memoryManager, AttributeStorage attributeStorage) {
        this.transformer = transformer;
        this.underlyingInput = underlyingInput;
        this.memoryManager = memoryManager;
        this.attributeStorage = attributeStorage;
        this.inputBufferAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("TransformerInput-" + transformer.getName());
    }

    @Override
    protected void onOpenInputSource() throws IOException {
        this.underlyingInput.notifyCondition(new TransformerCondition(), new TransformerCompletionHandler());
    }

    @Override
    protected void onCloseInputSource() throws IOException {
    }

    public final class TransformerCondition
    implements Condition {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean check() {
            try {
                Buffer chunkBuffer;
                boolean hasSavedBuffer;
                CompositeBuffer savedBuffer = (CompositeBuffer)TransformerInput.this.inputBufferAttr.get(TransformerInput.this.attributeStorage);
                Buffer bufferToTransform = savedBuffer;
                boolean bl = hasSavedBuffer = savedBuffer != null;
                if (TransformerInput.this.underlyingInput.isBuffered()) {
                    chunkBuffer = TransformerInput.this.underlyingInput.takeBuffer();
                } else {
                    int size = TransformerInput.this.underlyingInput.size();
                    chunkBuffer = TransformerInput.this.memoryManager.allocate(size);
                    while (size-- >= 0) {
                        chunkBuffer.put(TransformerInput.this.underlyingInput.read());
                    }
                    chunkBuffer.flip();
                }
                if (hasSavedBuffer) {
                    savedBuffer.append(chunkBuffer);
                } else {
                    bufferToTransform = chunkBuffer;
                }
                while (bufferToTransform.hasRemaining()) {
                    TransformationResult<Buffer, Buffer> result = TransformerInput.this.transformer.transform(TransformerInput.this.attributeStorage, bufferToTransform);
                    TransformationResult.Status status = result.getStatus();
                    if (status == TransformationResult.Status.COMPLETE) {
                        Buffer outputBuffer = result.getMessage();
                        TransformerInput.this.lock.writeLock().lock();
                        try {
                            TransformerInput.this.append(outputBuffer);
                            if (TransformerInput.this.isCompletionHandlerRegistered) continue;
                            boolean bl2 = true;
                            return bl2;
                        }
                        finally {
                            TransformerInput.this.lock.writeLock().unlock();
                            continue;
                        }
                    }
                    if (status == TransformationResult.Status.INCOMPLETE) {
                        if (hasSavedBuffer) return false;
                        if (bufferToTransform.isComposite()) {
                            TransformerInput.this.inputBufferAttr.set(TransformerInput.this.attributeStorage, (CompositeBuffer)bufferToTransform);
                            return false;
                        }
                        savedBuffer = CompositeBuffer.newBuffer(TransformerInput.this.memoryManager);
                        savedBuffer.append(bufferToTransform);
                        TransformerInput.this.inputBufferAttr.set(TransformerInput.this.attributeStorage, savedBuffer);
                        return false;
                    }
                    if (status == TransformationResult.Status.ERROR) throw new TransformationException(result.getErrorDescription());
                }
                return false;
            }
            catch (IOException e) {
                throw new TransformationException(e);
            }
        }
    }

    public final class TransformerCompletionHandler
    extends EmptyCompletionHandler<Integer> {
        @Override
        public void failed(Throwable throwable) {
            TransformerInput.this.notifyFailure(TransformerInput.this.completionHandler, throwable);
            TransformerInput.this.future.failure(throwable);
        }
    }
}

