/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.common;

import io.hops.hadoop.shaded.org.apache.commons.io.FileUtils;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.X509KeyType;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.X509TestContext;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import io.hops.hadoop.shaded.org.bouncycastle.jce.provider.BouncyCastleProvider;
import java.io.File;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public abstract class BaseX509ParameterizedTestCase
extends ZKTestCase {
    protected static Map<Integer, X509TestContext> cachedTestContexts;
    protected static File tempDir;
    protected X509TestContext x509TestContext;

    public static Collection<Object[]> defaultParams() {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        int paramIndex = 0;
        for (X509KeyType caKeyType : X509KeyType.values()) {
            for (X509KeyType certKeyType : X509KeyType.values()) {
                for (String keyPassword : new String[]{"", "pa$$w0rd"}) {
                    result.add(new Object[]{caKeyType, certKeyType, keyPassword, paramIndex++});
                }
            }
        }
        return result;
    }

    @BeforeClass
    public static void setUpBaseClass() throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        cachedTestContexts = new HashMap<Integer, X509TestContext>();
        tempDir = ClientBase.createEmptyTestDir();
    }

    @AfterClass
    public static void cleanUpBaseClass() {
        Security.removeProvider("BC");
        cachedTestContexts.clear();
        cachedTestContexts = null;
        try {
            FileUtils.deleteDirectory((File)tempDir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected BaseX509ParameterizedTestCase(Integer paramIndex, Supplier<X509TestContext> contextSupplier) {
        if (cachedTestContexts.containsKey(paramIndex)) {
            this.x509TestContext = cachedTestContexts.get(paramIndex);
        } else {
            this.x509TestContext = contextSupplier.get();
            cachedTestContexts.put(paramIndex, this.x509TestContext);
        }
    }
}

